/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServerUtility;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.upgrade.ConfigUpgrade;
import com.sonicsw.mf.common.config.upgrade.ConfigurationDependencies;
import com.sonicsw.mf.common.config.upgrade.IMigrationProcess;

public class UpgradePluginAction extends BasicPluginAction
{
	
    public UpgradePluginAction(IConfigPlugin plugin)
    {
        super(plugin, "upgrade.plugin");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        try
        {
            String name = getPlugin().getPluginPath();

            // getDependencies will return a vector where the clusters
            // appear after the member brokers. This plugin action needs to
            // call the upgrade for each configuration in the order that the 
            // configuration appear in the vector.
            Vector dependencies = getDependencies(name);

            JDependenciesDialog dialog =
                new JDependenciesDialog(MgmtConsole.getMgmtConsole(),
                                        name,
                                        dependencies);
            dialog.setVisible(true);
            
            if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
            {
                upgrade(dependencies, dialog.getControlNumber());
            }
        }
        catch(Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "Failed to upgrade configurations.", e, true);
        }
    }

    @Override
    public boolean isEnabled()
    {
        IPlugin plugin = getPlugin();
        PluginAttributes attrs = plugin.getAttributes();

        return ConfigUpgrade.isUpgradeSupported(attrs.getType(), attrs.getProductVersion());
    }

    private void upgrade(final Vector dependencies, final String controlNumber) throws Exception
    {
        Thread t = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

                try
                {
                    IDirectoryFileSystemService ds = getPlugin().getPluginContext().
                        getConnectionInfo().getDirectoryService();

                    //getDependencies will return a vector where the clusters
                    // appear after the member brokers. This plugin action needs to
                    // call the upgrade for each configuration in the order that the 
                    // configuration appear in the vector.
                    upgrade(dependencies, ds, controlNumber);

                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_INFO,
                        "Upgrade of configuration(s) complete.", true);
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                        "Failed to upgrade configuration(s) " + e.getMessage(), e, true);
                }
                finally
                {
                    wc.release();
                }
            }
        });
        t.start();
    }

    private void upgrade(Vector configs, IDirectoryFileSystemService ds, String controlNumber) throws Exception
    {
    	Properties upgradeEnv = new Properties();
    	// Until we fix the SMC upgrade, this control code entered could be for any of the
    	// components needing one, so put it in as all of them
    	upgradeEnv.put(IMigrationProcess.BROKERCNPROP, controlNumber);
    	upgradeEnv.put(IMigrationProcess.DOMAINPROP, ds.getDomain());
    	upgradeEnv.put(IMigrationProcess.DEBUGPROP, new Boolean(System.getProperty("DebugAll.debug", "false").equals("true")));
    	ConfigUpgrade configUpgrade = new ConfigUpgrade(ds, upgradeEnv);
    	configUpgrade.upgradeConfigs(configs);
    }

    private Vector getDependencies(String path) throws Exception
    {
        IDirectoryFileSystemService ds = getPlugin().getPluginContext().
                getConnectionInfo().getDirectoryService();

        ConfigurationDependencies cd = new ConfigurationDependencies(ds);//ConfigurationDependencies.setDirectoryService((IDirectoryAdminService)ds, ds);
        HashMap containerComponentMap = cd.findConfigDependencies(path);
        Vector configNames = new Vector();
        java.util.Iterator idsIterator = containerComponentMap.keySet().iterator();
        while (idsIterator.hasNext())
        {
            configNames.add(((IElementIdentity)idsIterator.next()).getName());
        }
        return configNames;
    }

    //-------------- Inner classes ----------------

    class JDependenciesDialog extends JMADialog
    {
        private String m_name;
        private Vector m_dependencies;
        private JTextField m_controlNumber = new JTextField("");

        public JDependenciesDialog(JMAFrame parent, String name, Vector dependencies)
        {
            super(parent, "upgrade.dependencies");

            m_name = name;
            m_dependencies = dependencies;
        }

        @Override
        public void maInitialize()
        {
            JTextArea textArea = new JTextArea(8, 32);
            filterNames(textArea);
            textArea.setBackground(UIManager.getColor("Panel.background"));
            textArea.setEditable(false);
            JPartitionPanel msgPanel = new JPartitionPanel(false, "p", "", 5, 5, 5);
            msgPanel.add(new JLabel("Upgrade the configuration for:"));
            msgPanel.add(new JLabel("'" + m_name + "'?"));

            JPartitionPanel dependPanel = new JPartitionPanel(true, "p,r", "", 5, 5, 5);
            dependPanel.add(new JLabel("The following configurations will be upgraded:"));
            dependPanel.add(new ExtendedJScrollPane(textArea));
            JPartitionPanel controlPanel = new JPartitionPanel(true, "p,p", "", 5, 5, 5);
            controlPanel.add(new JLabel(Helper.toHtml("If a licensed configuration (Broker) will be upgraded, enter a control number for the new version")));
            controlPanel.add(m_controlNumber);
            JPanel topPanel = new JPartitionPanel(true, "p,r,r", null);
            topPanel.add(msgPanel);
            topPanel.add(dependPanel);
            topPanel.add(controlPanel);
            getContentPane().add(topPanel);
        }

        public String getControlNumber()
        {
           return m_controlNumber.getText();
        }

        @Override
        public void maCleanup(){}

        //filters out "/_Default", just for display
        private void filterNames(JTextArea list)
        {
            for (int i = 0; i < m_dependencies.size(); i++)
            {
                String name = (String)m_dependencies.get(i);
                if (name.endsWith(ConfigServerUtility.DEFAULT_SUFFIX))
                {
                    name = name.substring(0, name.lastIndexOf('/'));
                }
                list.append(name + "\n");
            }
        }

    }
}