/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import java.util.HashMap;
import java.util.Map;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;

public abstract class AbstractConfigFolderElementPlugin extends AbstractConfigPlugin
{
    private static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.IS_CHILD_BEARING, Boolean.TRUE },
    };

    public AbstractConfigFolderElementPlugin(IPluginContext context, String id, Map data)
    {
        super(context, id, data);

        getAttributes().put(ATTRIBUTES);
    }

    /**
     * Release resources that the plugin is using
     */
    @Override
    public void dispose()
    {
        super.dispose();
    }

    @Override
    protected IContentPane createReadablePluginContentPane()
    {
        return new ConfigFolderContentPane(this);
    }

    @Override
    public BasicAction getDefaultAction()
    {
        return new FolderPluginExpandAction(this);
    }

    //-------------------------------------------------------------------------
    //
    // Model Manipulation
    //
    //-------------------------------------------------------------------------

    @Override
    public String _getPluginName()
    {
        return ConfigServerUtility.DEFAULT_SUFFIX;
    }

    @Override
    public String _getPluginPath()
    {
        return ConfigHelper.buildPath(super._getPluginPath(), _getPluginName());
    }

    @Override
    public Object createModel(IConfigServer server, boolean isTemplate)
    {
        Object model = null;

        try
        {
            String  path    = getPluginPath();
            HashMap metaMap = createModelMetaAttributes(isTemplate, false);

            server.createFolder(path, metaMap, false);

            model = super.createModel(server, isTemplate);
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                          "Failed to create model: " + getPluginPath(), e, false);
        }

        return model;
    }

    /*
    AHJ v6.0
    Derived class must create (and rename) missing directory and apply the
    "_Default" bean's meta attributes to the missing directory!!!!!

    Default behavior is to create the bean which will be offset from the
    missing directory.


    public Object createModel(boolean isTemplate)
    {
        Object model = null;

        try
        {
            IConfigServer server = getPluginContext().getConfigContext().getConfigServer();
            String        path   = getPluginPath();

            //
            // server.createDirectory(path);

            model = super.createModel(server, isTemplate);

            // This little 'hack' is used to put the '_Default' configuration's
            // meta attributes on the directory so we don't have to do any
            // performance-hitting lookup of the '_Default' element in order to
            // get at the meta attributes...
            //
            HashMap dirMap = createModelMetaAttributes(isTemplate, false);
            server.setMetaAttributes(path, dirMap);
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                          "Failed to create model: " + getPluginPath(), e, false);
        }

        return model;
    }
*/

    //-------------------------------------------------------------------------

    @Override
    public void copyPlugin(IConfigServer server, String path, Object copyData)
        throws Exception
    {
        Map         metaMap  = server.getMetaAttributes(getPluginPath());
        IConfigBean bean     = (IConfigBean)server.loadConfigElement(_getPluginPath());
        String      copyPath = ConfigHelper.buildPath(path, _getPluginName());
        IConfigBean copyBean = null;
        boolean     convert  = ((copyData != null) && copyData.equals(Boolean.TRUE));

        server.createFolder(path, convertMetaAttributes(metaMap, convert), false);

        if (convert)
        {
            // we want to convert the type of the config bean. If it
            // is a template create an instance, if an instance create
            // a template
            if (bean instanceof IConfigPrototype)
            {
                copyBean = (IConfigBean)((IConfigPrototype)bean).newInstance(copyPath);
            }
            else
            {
                copyBean = (IConfigBean)bean.createPrototype(copyPath);
            }
        }
        else
        {
            if (bean.isPrototypeInstance())
            {
                copyBean = (IConfigBean)bean.clonePrototypeInstance(copyPath);
            }
            else
            {
                copyBean = (IConfigBean)bean.clone();
                copyBean.setName(copyPath);
            }
        }

        copyBean.setMetaAttributes((HashMap)convertMetaAttributes(bean.getMetaAttributes(), convert));
    }
}
