package com.sonicsw.ma.gui.config;

import java.util.List;

import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.JRowTableAspectAdapter;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;

public class AbstractDomainFolderDialog extends JPropSheetTabbedDialog {
    protected JRowTable m_table;
    protected JTextField m_path         = new JTextField();
    protected JTextField m_type         = new JTextField();
    protected JCheckBox  m_system       = new JCheckBox();
    protected JTextField m_connection   = new JTextField();
    protected JTextField m_domainName   = new JTextField();
    protected JTextField m_url          = new JTextField();
    protected JTextField m_user         = new JTextField();
    protected JTextField m_timeout      = new JTextField();
    protected JTextField m_node         = new JTextField();
    protected JCheckBox m_useNode       = new JCheckBox();
    protected JCheckBox m_loadBalancing = new JCheckBox();


    public AbstractDomainFolderDialog(JMAFrame parent, Class modelClass) {
        this(parent,"domain",modelClass);
    }

    public AbstractDomainFolderDialog(JMAFrame parent, String name, Class modelClass) {
        super(parent, name, modelClass);
    }

    /**
     * Returns an array of button actions to use in the dialog.
     */
    @Override
    public Action[] getButtonActions()
    {
        return new Action[]
        {
            new CloseAction(getDefaultCancelAction()),
        };
    }

    /**
     * Overridden method to initialize the dialog GUI.
     */
    @Override
    public void initUI() throws Exception
    {
        String generalTab = ResourceManager.getString(getClass(), "dialog.domain.tab.general.label");
        String pluginsTab = ResourceManager.getString(getClass(), "dialog.domain.tab.plugins.label");
        String advancedTab = ResourceManager.getString(getClass(), "dialog.domain.tab.advanced.label");

        addTabPanel(generalTab, JPartitionPanel.wrap(createGeneralPanel()));
        addTabPanel(pluginsTab, createPluginPanel());
        contributeToUI();
        addTabPanel(advancedTab, JPartitionPanel.wrap(createAdvancedPanel()));
    }

    private JPanel createAdvancedPanel()
    {
        String paramGroup    = ResourceManager.getString(getClass(), "dialog.domain.advanced.group.parameters.label");
        String routeGroup    = ResourceManager.getString(getClass(), "dialog.domain.advanced.group.manage.label");
        String timeout       = ResourceManager.getString(getClass(), "dialog.domain.advanced.timeout.label");
        String useNode       = ResourceManager.getString(getClass(), "dialog.domain.advanced.use_node.label");
        String node          = ResourceManager.getString(getClass(), "dialog.domain.advanced.node.label");
        String loadBalancing = ResourceManager.getString(getClass(), "dialog.domain.advanced.load_balancing.label");

        JPartitionPanel panel = new JPartitionPanel(true, "p,p,r", null, 0, 0, 0);

        String unitSec = ResourceManager.getString(getClass(), new Object[]
            {ResourceManager.KEY_UNIT, "seconds"});

        JPartitionPanel panel1 = new JPartitionPanel(paramGroup);
        panel1.addRow(timeout, m_timeout, unitSec);
        panel1.addRow(loadBalancing, m_loadBalancing);

        JPartitionPanel panel2 = new JPartitionPanel(routeGroup);
        panel2.addRow(useNode, m_useNode);
        panel2.addRow(node, m_node);

        panel.add(panel1);
        panel.add(panel2);

        return panel;
    }

    protected void contributeToUI() {
    }

    /**
     * Overridden method to initialize the data for the dialog GUI.
     */
    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("path"),  m_path,   EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"),  m_type,   EditRule.NEVER, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"), m_system, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("connectionName"), m_connection, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("domainName"), m_domainName, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("url"), m_url, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("userName"), m_user, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("timeout"), m_timeout, EditRule.NEVER, new IntToStringConverter(), getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("managementNode"), m_node, EditRule.NEVER, null, getMediator());
        new JTableListAdapter(ModelAspectId.forName("pluginFactories"), m_table, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("usingManagement"), m_useNode, EditRule.NEVER, null, getMediator(), false);
        new JCheckBoxAdapter(ModelAspectId.forName("loadBalancing"), m_loadBalancing, EditRule.NEVER, null, getMediator(), false);
    }


    @Override
    protected void maCleanup()
    {
        super.maCleanup();

        if (m_table != null)
        {
            m_table.cleanup();
        }
    }

    protected JPanel createGeneralPanel()
    {
        JPanel panel = new JPanel(new java.awt.BorderLayout(0,0));

        JPartitionPanel panelTop = new JPartitionPanel(false, "p,r", "");

        panelTop.addRow(ResourceManager.getString(getClass(), "dialog.file-element.path.label"),   m_path);
        panelTop.addRow(ResourceManager.getString(getClass(), "dialog.file-element.type.label"),   m_type);
        panelTop.addRow(ResourceManager.getString(getClass(), "dialog.file-element.system.label"), m_system);

        panel.add(panelTop, java.awt.BorderLayout.CENTER);

        JPartitionPanel panelBottom = new JPartitionPanel(false, "p,r", ResourceManager.getString(getClass(), "dialog.domain.general.parameters.label"));

        panelBottom.addRow(ResourceManager.getString(getClass(), "dialog.domain.general.connection_name.label"), m_connection);
        panelBottom.addRow(ResourceManager.getString(getClass(), "dialog.domain.general.domain_name.label"), m_domainName);
        panelBottom.addRow(ResourceManager.getString(getClass(), "dialog.domain.general.connection_url.label"), m_url);
        panelBottom.addRow(ResourceManager.getString(getClass(), "dialog.domain.general.user_name.label"), m_user);

        panel.add(panelBottom, java.awt.BorderLayout.SOUTH);

        return panel;
    }

    private JPanel createPluginPanel()
    {
        String name     = ResourceManager.getString(getClass(), "dialog.domain.plugin.table.column.name.label");
        String vProduct = ResourceManager.getString(getClass(), "dialog.domain.plugin.table.column.product_version.label");
        String vConfig  = ResourceManager.getString(getClass(), "dialog.domain.plugin.table.column.config_version.label");
        String revision = ResourceManager.getString(getClass(), "dialog.domain.plugin.table.column.revision.label");

        JPanel outerPanel = new JPartitionPanel(false, "r", null);

        TableColumn[] COLUMNS =
            {
            new StringTableColumn(0, name,     StringTableColumn.NAME_COLUMN_HEADING,            40),
            new StringTableColumn(1, vProduct, StringTableColumn.PRODUCT_VERSION_COLUMN_HEADING, 20),
            new StringTableColumn(2, vConfig,  StringTableColumn.CONFIG_VERSION_COLUMN_HEADING,  20),
            new StringTableColumn(3, revision, StringTableColumn.REVISION_COLUMN_HEADING,        20),
        };

        m_table = new JRowTable(COLUMNS, getClass().getName());
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(m_table);
        outerPanel.add(scrollPane);

        return outerPanel;
    }



    @Override
    protected boolean canClose() //Sonic00023675 overrides base, we always can close
    {
        return true;
    }

    /**
     * Class to override the normal Close action and behave as a Cancel action.
     */
    public class CloseAction extends BasicGuiAction
    {
        /**
         * Constructor to create the action.
         *
         * @param targetAction The action to use
         */
        public CloseAction(Action targetAction)
        {
            this("dialog.close", targetAction);
        }
        
        /**
         * Constructor to create the action, with label.
         *
         * @param targetAction The action to use
         */
        public CloseAction(String name,Action targetAction)
        {
            super(name, targetAction);
        }

    }

    /**
     * Class to handle table column adapters for String data types.
     */
    class StringTableColumn extends RowTableColumn
    {
        public static final int NAME_COLUMN_HEADING            = 0;
        public static final int PRODUCT_VERSION_COLUMN_HEADING = 1;
        public static final int CONFIG_VERSION_COLUMN_HEADING  = 2;
        public static final int REVISION_COLUMN_HEADING        = 3;

        protected int m_index;

        public StringTableColumn(int modelIndex, String name, int id, int width)
        {
            super(modelIndex, name, width);

            m_index = id;
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            String value = "";

            if (rowModel != null)
            {
                if (!(rowModel instanceof IPluginFactory))
                {
                    return value;
                }
                else
                {
                    PluginAttributes attributes = ((IPluginFactory)rowModel).getAttributes();

                    switch (m_index)
                    {
                        case NAME_COLUMN_HEADING:
                            value = attributes.getDisplayType();
                            break;
                        case PRODUCT_VERSION_COLUMN_HEADING:
                            value = attributes.getProductVersionsString();
                            break;
                        case CONFIG_VERSION_COLUMN_HEADING:
                            value = attributes.getConfigVersion();
                            break;
                        case REVISION_COLUMN_HEADING:
                            value = attributes.getPluginRevision();
                            break;
                    }
                }
            }
            return value;
        }
    }

    class JTableListAdapter extends JRowTableAspectAdapter
    {
        public JTableListAdapter(ModelAspectId modelAspectId,
                                 JRowTable table,
                                 ModelEditMediator modelEditMediator)
        {
            super(modelAspectId, table, null, EditRule.NEVER, modelEditMediator);
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue)
            throws IllegalArgumentException
        {
            ((IModelTableModel) table.getModel()).setContents((List) viewAspectValue);
        }
    }
}
