
package com.sonicsw.ma.gui.config;

import java.io.File;
import java.text.MessageFormat;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.ResourceManager;

/**
 * <p>Title: BootFileChooser</p>
 * <p>Description: A custom JFileChooser that targets (Container/DS) boot file
 * generation.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author hjones
 * @version 1.0
 */
public class BootFileChooser extends JFileChooser
{
    private static final String TITLE = "Verify Boot File Location";
    private static final String MSG   = "The file ''{0}'' already exists.  Do you want to replace the existing file?";

    public BootFileChooser() { super(); }

    @Override
    public void approveSelection()
    {
        File selection = getSelectedFile();
        int save = JOptionPane.YES_OPTION;

        if (selection.exists())
        {
            String msg = MessageFormat.format(RES(MSG), new Object[] { selection.getName() });

            save = JOptionPane.showConfirmDialog(MgmtConsole.getMgmtConsole(), msg, RES(TITLE), JOptionPane.YES_NO_OPTION);
        }

        if (save == JOptionPane.YES_OPTION)
        {
            super.approveSelection();
        }
    }

    private String RES(String english)
    {
        String res = ResourceManager.getString(getClass(), english);

        return (res == null) ? english : res;
    }
}
