package com.sonicsw.ma.gui.config;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;

public class ComponentChooserDialog extends JPropSheetDialog
{
    private JLightConfigTree  m_tree;
    private IPluginFilter     m_filter;
    private boolean           m_multiSelect;
    private IConfigServer     m_server;
    private IPluginContext    m_context;
    private JPanel            m_generalPanel;


    public ComponentChooserDialog(JPropSheetDialog  parent,
                                  String            name,
                                  IPluginContext    context,
                                  IConfigServer     server,
                                  IPluginFilter     filter,
                                  boolean           multiSelect)
    {
        super(parent, name, HashMap.class);

        m_context     = context;
        m_server      = server;
        m_filter      = filter;
        m_multiSelect = multiSelect;
    }

    public ComponentChooserDialog(JMAFrame        parent,
                                   String         name,
                                   IPluginContext context,
                                   IConfigServer  server,
                                   IPluginFilter  filter,
                                   boolean        multiSelect)
    {
        super(parent, name, HashMap.class);

        m_context     = context;
        m_server      = server;
        m_filter      = filter;
        m_multiSelect = multiSelect;
    }

    @Override
    public void maCleanup()
    {
        super.maCleanup();

        m_context = null;
        m_tree    = null;
        m_filter  = null;
        m_server  = null;
    }

    @Override
    public void initUI() throws Exception
    {
        m_generalPanel = makeGeneralPanel();
        getContentPane().add(m_generalPanel);

        updateState();
    }

    @Override
    public void initForm() throws Exception
    {
    }

    public JPanel getGeneralPanel()
    {
        return m_generalPanel;
    }

    public IPluginFilter getFilter()
    {
        return m_filter;
    }

    protected void updateTree()
    {
        m_tree.rebuildTree(m_server, m_filter);
    }

    private JPanel makeGeneralPanel()
    {
        m_tree = new JLightConfigTree(m_context, m_server, "/", m_filter);

        m_tree.setRootLabel("Domain");
        m_tree.setRootIcon(ResourceManager.getTypeIcon(ConfigDomainFolderPlugin.PLUGIN_TYPE));
        m_tree.expandRow(0);
        m_tree.getSelectionModel().setSelectionMode(m_multiSelect ? TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION
                                                                  : TreeSelectionModel.SINGLE_TREE_SELECTION);
        m_tree.addTreeSelectionListener(new TreeSelectionListener()
        {
            @Override
            public void valueChanged(TreeSelectionEvent evt)
            {
                updateState();
            }
        });
        m_tree.addMouseListener(new MouseAdapter()
        {
            @Override
            public void mouseClicked(MouseEvent evt)
            {
                if (evt.getClickCount() == 2)
                {
                    TreePath path = m_tree.getPathForLocation(evt.getX(), evt.getY());

                    if ((path == null) || !(((TreeNode)path.getLastPathComponent()).isLeaf()))
                    {
                        return;
                    }

                    try
                    {
                        JButtonPanel btnPanel = (JButtonPanel)ComponentChooserDialog.this.getButtonPanel();
                        String       okCommand = (String)getDefaultOKAction().getValue(Action.ACTION_COMMAND_KEY);

                        btnPanel.getButton(okCommand).doClick();
                    }
                    catch (Exception e)
                    {
                        MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Error making the general panel.", e, true);
                    }
                }
            }
        });

        JPartitionPanel panel          = new JPartitionPanel(true, "r,p", null);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(m_tree);

        panel.add(scrollPane);

        return panel;
    }

    private void updateState()
    {
        TreePath[] path      = m_tree.getSelectionPaths();
        String     okCommand = (String)getDefaultOKAction().getValue(Action.ACTION_COMMAND_KEY);
        JButton    okBtn     = ((JButtonPanel)getButtonPanel()).getButton(okCommand);
        Action     okAction  = okBtn.getAction();

        boolean state = true;

        if ((path == null) || (path.length == 0))
        {
            state = false;
        }
        else
        if ((path.length > 1) && !m_multiSelect)
        {
            state = false;
        }
        else
        {
            for (int i = 0; i < path.length; i++)
            {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[i].getLastPathComponent();

                if (!m_tree.isNodeTyped(node))
                {
                    state = false;
                    break;
                }
            }
        }

        okAction.setEnabled(state);
    }

    @Override
    public Action[] getButtonActions()
    {
        ArrayList list = new ArrayList();

        list.add(new AddAction(getDefaultOKAction()));
        list.add(getDefaultCancelAction());

        return (Action[])list.toArray(new Action[list.size()]);
    }

    class AddAction extends BasicGuiAction
    {
        public AddAction(Action target)
        {
            super(null, target);

            setCheckTargetValue(true);
        }

        private String convertTreeToViewPath(TreePath path)
        {
            StringBuffer sb = new StringBuffer();

            // Start at 1 (to skip the view's _rootFolder thingy which isn't
            // needed (or handled correctly) but the ViewManager's view
            // to DS conversion method below...
            //
            for (int j = 1; j < path.getPathCount(); j++)
            {
                sb.append('/').append(path.getPathComponent(j).toString());
            }

            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            TreePath[] paths = m_tree.getSelectionPaths();

            if (paths != null)
            {
                HashMap map = (HashMap)ComponentChooserDialog.this.getModel();

                for (int i = 0; i < paths.length; i++)
                {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    String type = (String)((HashMap)node.getUserObject()).get(ConfigServerUtility.TYPE);
                    String name = node.toString();

                    // prevent adding components that already in a map
                    //
                    if (!map.containsKey(name))
                    {
                        map.put(name, type);
                    }
                }
            }

            super.actionPerformed(evt);
        }
    }

}
