/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;

public abstract class ComponentPlugin extends AbstractConfigPlugin
{
    public static final IConfigPath CLASSNAME = ConfigFactory.createConfigPath("CLASSNAME");
    public static final String TRACKID_TOOLS = "MANAGED_TOOLS_DIALOG";
    private MetricsModel       m_metricsModel;

    public ComponentPlugin(IPluginContext context, String id, Map data)
    {
        super(context, id, data);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        return null;
    }

    @Override
    public boolean expand()
    {
        return false;
    }


    @Override
    public String[] getAllSupportedMonitors() {
        ArrayList res = new ArrayList();
        if (isMonitorSupported(IMonitorPlugin.MONITOR_ID_METRICS_CONFIG))
        {
            res.add(IMonitorPlugin.MONITOR_ID_METRICS_CONFIG);
        }
        return (String[])res.toArray(new String[res.size()]);
    }

    @Override
    public boolean isMonitorSupported(String monitorId)
    {
        boolean res = false;
        if (monitorId != null)
        {
            if (monitorId.equals(IMonitorPlugin.MONITOR_ID_METRICS_CONFIG)) {

                String type = getAttributes().getType();
                    String cVersion = getAttributes().getConfigVersion();
                    String path ="/meta-inf/" + type + "/" + cVersion + "/metrics";
                res = (getMetricInfo(path) != null);
            }
        }
        return res;
    }

    @Override
    public Object getMonitorModel(String monitorId)
    {
        Object res = null;

        if (isMonitorSupported(monitorId))
        {
            if (monitorId.equals(IMonitorPlugin.MONITOR_ID_METRICS_CONFIG))
            {
                try
                {
                    IRemoteMBeanServer server = getPluginContext().getRuntimeContext().getMBeanServer();
                    String domainName = getPluginContext().getConnectionInfo().getDomainName();
                    String type = getAttributes().getType();
                    String cVersion = getAttributes().getConfigVersion();
                    String path ="/meta-inf/" + type + "/" + cVersion + "/metrics";
                    IMetricInfo[]      info   = getMetricInfo(path);
                    m_metricsModel = new MetricsModel(server,new ObjectName(domainName+ "." + getPluginName() + ":ID=AGENT") , info);
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                              "Failed to get metrics info: " + e.getMessage(), e, false);

                    m_metricsModel = null;
                }
                res = m_metricsModel;
            }
        }
        return res;
    }
    public IMetricInfo[] getMetricInfo(String path)
     {
         IMetricInfo[] res = null;
         try {
             DirectoryServiceProxy directoryService = getDS();
             IDirElement element = directoryService.getElement(path, true);
             IAttributeSet attributes = element.getAttributes();
             Set keys = attributes.getAttributes().keySet();
             res = new IMetricInfo[keys.size()];
             Iterator iterator = keys.iterator();
             int ctr=0;
             while (iterator.hasNext()) {
                 String key = (String) iterator.next();
                 AttributeSet attribSet = (AttributeSet) attributes.getAttribute(key);
                res[ctr++]=createMetricInfo(attribSet,key);
             }
         } catch (Exception e) {
//             e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
             MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
         }
         return res;
     }

    private IMetricInfo createMetricInfo(AttributeSet attribSet,String key){
        String ATTRIB_VALUE_TYPE = "VALUE_TYPE";
        String ATTRIB_DESCRIPTION = "DESCRIPTION";
        String ATTRIB_EXTENDED_DATA = "EXTENDED_DATA";
        String ATTRIB_INSTANCE_METRIC = "INSTANCE_METRIC";
        String ATTRIB_DYNAMIC = "DYNAMIC";
        String ATTRIB_SUPPORTS_HIGH_THRESHOLDS = "SUPPORTS_HIGH_THRESHOLDS";
        String ATTRIB_SUPPORTS_LOW_THRESHOLDS = "SUPPORTS_LOW_THRESHOLDS";
        String ATTRIB_UNITS = "";
        short valueType = 0;
        String description = "";
        String extData = "";
        boolean instanceMetric = false;
        boolean dynamic = false;
        boolean supportsHighThreshold = false;
        boolean supportsLowThreshold = false;
        String units = "";

        try {
            final Object attribValueType = attribSet.getAttribute(ATTRIB_VALUE_TYPE);
            if (attribValueType instanceof Number) {
                valueType = ((Number) attribValueType).shortValue();
            } else {
                valueType = Short.parseShort((String) attribValueType);
            }
        } catch (Exception e) {
            valueType=0;
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            description =(String) attribSet.getAttribute(ATTRIB_DESCRIPTION);
        } catch (Exception e) {
            description="";
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            extData =(String) attribSet.getAttribute(ATTRIB_EXTENDED_DATA);
        } catch (Exception e) {
            extData="";
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            Object attribute = attribSet.getAttribute(ATTRIB_INSTANCE_METRIC);
            instanceMetric =((Boolean) attribute).booleanValue();
        } catch (Exception e) {
            instanceMetric=false;
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            dynamic =((Boolean)attribSet.getAttribute(ATTRIB_DYNAMIC)).booleanValue();
        } catch (Exception e) {
            dynamic=false;
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            supportsHighThreshold =((Boolean) attribSet.getAttribute(ATTRIB_SUPPORTS_HIGH_THRESHOLDS)).booleanValue();
        } catch (Exception e) {
            supportsHighThreshold=false;
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            supportsLowThreshold =((Boolean) attribSet.getAttribute(ATTRIB_SUPPORTS_LOW_THRESHOLDS)).booleanValue();
        } catch (Exception e) {
            supportsLowThreshold=false;
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        try {
            units =(String) attribSet.getAttribute(ATTRIB_UNITS);
        } catch (Exception e) {
            units="";
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        IMetricIdentity metricIdentity = MetricsFactory.createMetricIdentity(key);
        return MetricsFactory.createMetricInfo(metricIdentity, valueType, description,extData, instanceMetric,dynamic,supportsHighThreshold,supportsLowThreshold,units);
    }



    private DirectoryServiceProxy getDS() throws MalformedObjectNameException {
        DomainConnectionModel connectionInfo = getPluginContext().getConnectionInfo();
        JMSConnectorClient    server  = (JMSConnectorClient)connectionInfo.getMBeanServer();
        String domain =connectionInfo.getDomainName();
        String dsName = domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
        DirectoryServiceProxy proxy = new DirectoryServiceProxy(server, new ObjectName(dsName));
        return proxy;
    }


}
