/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.LongToStringConverter;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBrowseButton;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.QueryConverter;
import com.sonicsw.ma.gui.util.ReferenceToStringConverter;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;

public class ConfigDomainFolderDialog extends AbstractDomainFolderDialog {

    //MQ3
    protected JCheckBox enableSecurity = new JCheckBox();
    protected JComboBox authenticationDomains = new JComboBox();
    private MyQueryConverter authDomainConverter;
    //MQ4
    protected JCheckBox auditConfigChanges = new JCheckBox();
    protected JCheckBox auditMgmtOps = new JCheckBox();
    protected JCheckBox propogateAuditToDS = new JCheckBox();

    protected JTextField configFile = new JTextField();
    protected JButton configFileChooser = new JBrowseButton();

    protected JCheckBox enableCentralizedLogging = new JCheckBox();
    protected JTextField centralizedLogDir = new JTextField();
    protected JTextField logFileThreshold = new JTextField();
    protected JTextField logFileRolloverThreshold = new JTextField();
    protected JTextField logFileRolloverTimeInterval = new JTextField();
    /**
     * Constructor to create the dialog and initialize its' data model.
     */
    public ConfigDomainFolderDialog(JMAFrame parent) {
        this(parent, ConfigDomainFolderPluginModel.class);
    }

    protected ConfigDomainFolderDialog(JMAFrame parent, Class modelClass) {
        super(parent, "domain", modelClass);
    }

    @Override
    public void initForm() throws Exception {
        super.initForm();
        new JCheckBoxAdapter(ModelAspectId.forName("securityEnabled"), enableSecurity, EditRule.ALWAYS, null, getMediator());
        authDomainConverter = new MyQueryConverter(getPlugin().getPluginContext().getConfigContext().getConfigServer(), "MF_AUTHENTICATION_DOMAIN", ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX);
        new JComboBoxAdapter(ModelAspectId.forName("authenticationDomain"), authenticationDomains, EditRule.ALWAYS, authDomainConverter, getMediator());

        new JCheckBoxAdapter(ModelAspectId.forName("auditConfigureEvents"), auditConfigChanges, EditRule.ALWAYS, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("auditManageEvents"), auditMgmtOps, EditRule.ALWAYS, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("enableCentralizedAudit"), propogateAuditToDS, EditRule.ALWAYS, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("defautlManagementAuditConfig"), configFile, EditRule.ALWAYS, null, getMediator());

        new JCheckBoxAdapter(ModelAspectId.forName("enforeCentralizedLogging"), enableCentralizedLogging, EditRule.ALWAYS, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("centralizedLogFile"), centralizedLogDir, EditRule.ALWAYS, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileSizeThreshold"), logFileThreshold, EditRule.ALWAYS, new LongToStringConverter(), getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileRolloverSizeThreshold"), logFileRolloverThreshold, EditRule.ALWAYS, new LongToStringConverter(), getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("logFileRolloverTimeInterval"), logFileRolloverTimeInterval, EditRule.ALWAYS, new IntToStringConverter(), getMediator());
    }

    @Override
    protected void maInitialize() {
        refreshModel();
        if (!isAdmin()) {
            enableSecurity.setEnabled(false);
            authenticationDomains.setEnabled(false);
        } else {
            if (!isSecEnabled()) {
                authenticationDomains.setEnabled(false);
            }
        }
        checkForAnyAudit();
        super.maInitialize();
    }           

    @Override
    protected void contributeToUI() {
        String securityAuditingTab = ResourceManager.getString(getClass(), "dialog.domain.tab.security.label");
        String loggingAuditingTab = ResourceManager.getString(getClass(), "dialog.domain.tab.logging_and_auditing.label");

        addTabPanel(securityAuditingTab, JPartitionPanel.wrap(createSecurityAuditingPanel()));
        addTabPanel(loggingAuditingTab, JPartitionPanel.wrap(createLoggingAuditingPanel()));
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[]
        {
            new OKAction(getDefaultOKAction()),
            new CloseAction("dialog.cancel",getDefaultCancelAction())
        };
    }


    protected JPanel createSecurityAuditingPanel() {
        JPanel panel = new JPanel(new java.awt.BorderLayout(0, 0));


        JPartitionPanel mgmtPermsGroup = new JPartitionPanel(false, "p,r", ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.mgmt_perms.title"));

        mgmtPermsGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.mgmt_perms.enable.label"), enableSecurity);
        enableSecurity.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                if(enableSecurity.isSelected()) {
                    authenticationDomains.setEnabled(true);
                    authenticationDomains.setSelectedItem(authDomainConverter.getDefaultDomain());
                } else {
                    authenticationDomains.setSelectedItem(authDomainConverter.getNone());
                    authenticationDomains.setEnabled(false);
                }
            }
        });
//        mgmtPermsGroup.addRow(new JComponent[]{new JLabel("Warning: Enforcement requires enablement of" ),new JLabel("security and JMSXUserID features at all management brokers.")});
        // todo. this is a dirty thing to do.
        mgmtPermsGroup.addRow(new JComponent[]{new JLabel("Warning: Enforcement requires enablement of" ),new JLabel("security and JMSXUserID features at all management brokers.")});
        mgmtPermsGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.mgmt_perms.authentication_domain.label"), authenticationDomains);

        panel.add(mgmtPermsGroup, java.awt.BorderLayout.NORTH);

        return panel;
    }

    protected JPanel createLoggingAuditingPanel(){
        JPanel panel = new JPanel(new java.awt.BorderLayout(0, 0));

        JPartitionPanel loggingGroup = new JPartitionPanel(false, "p,r,p", ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.title"));

        loggingGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.enable_centralized_logging.label"), enableCentralizedLogging);
        loggingGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.centralized_log_dir.label"), centralizedLogDir);
        loggingGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.log_file_threshold.label"), logFileThreshold,"bytes");
        loggingGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.log_file_rollover_threshold.label"), logFileRolloverThreshold,"bytes");
        loggingGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.logging_and_auditing.logging.log_file_rollover_time_interval.label"), logFileRolloverTimeInterval,"minutes");

        panel.add(loggingGroup, java.awt.BorderLayout.NORTH);

        JPartitionPanel auditGroup = new JPartitionPanel(false, "p,r,p", ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.auditing.title"));

        auditGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.auditing.enable_audit_config_changes.label"), new JComponent[]{auditConfigChanges});
        auditGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.auditing.enable_audit_mgmt_ops.label"), new JComponent[]{auditMgmtOps});
        auditGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.auditing.enable_propagate_audit.label"), new JComponent[]{propogateAuditToDS});
        auditGroup.addRow(ResourceManager.getString(getClass(), "dialog.domain.security_and_auditing.auditing.default_log4j.label"), new JComponent[]{configFile, configFileChooser});

        ActionListener l = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                checkForAnyAudit();
            }
        };
        auditConfigChanges.addActionListener(l);
        auditMgmtOps.addActionListener(l);

        configFileChooser.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String file = Utils.chooseFile(ConfigDomainFolderDialog.this, getPlugin(), ManagementSecurityUtils.getAllowedLog4jConfigExtensions());
                if(file!=null)
                {
                    configFile.setText(file);
                }
            }
        });
        panel.add(auditGroup, java.awt.BorderLayout.SOUTH);


        return panel;
    }


    private void checkForAnyAudit() {
        boolean anyAudit = auditConfigChanges.isSelected() || auditMgmtOps.isSelected();
        if(propogateAuditToDS.isSelected() && !anyAudit)
        {
            propogateAuditToDS.setSelected(false);
        }
        propogateAuditToDS.setEnabled(anyAudit);
        configFile.setEnabled(anyAudit);
        configFileChooser.setEnabled(anyAudit);
    }

    /**
     * Class to override the normal Close action and behave as a Cancel action.
     */
    public class OKAction extends BasicGuiAction
    {
        private static final long MIN_ROLLOVER_TIME = 1;
        private static final long MAX_ROLLOVER_TIME = 1440;

        /**
         * Constructor to create the action.
         *
         * @param targetAction The action to use
         */
        public OKAction(Action targetAction)
        {
            super("dialog.ok", targetAction);
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            if(validateLogRolloverTimeInterval())return ;
            super.actionPerformed(evt);
        }

        private boolean validateLogRolloverTimeInterval()
        {
            int value;
            try
            {
                value = (new Integer(logFileRolloverTimeInterval.getText()))
                        .intValue();

                if (value < MIN_ROLLOVER_TIME)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, "Rollover time interval cannot be less than 1 minute.", true);
                    return true;
                }
                if (value > MAX_ROLLOVER_TIME)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, "Rollover time interval cannot be greater than 1440 minutes", true);
                    return true;
                }
            }
            catch (Exception e)
            {
                MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, "Not a valid value", e, true);
            }
            return false;
        }
    }

    private boolean isAdmin(){
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin) getPlugin();
        return plugin.getPluginContext().getConnectionInfo().getUserName().equals("Administrator");
    }

    private boolean isSecEnabled(){
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin) getPlugin();
        return ((ConfigDomainFolderPluginModel) plugin.getModel()).getSecurityEnabled();
    }

    private void refreshModel(){
        ConfigDomainFolderPlugin plugin = (ConfigDomainFolderPlugin) getPlugin();
        ((ConfigDomainFolderPluginModel) plugin.getModel()).initSecurityAndAuditSettings();
    }


    @Override
    protected boolean canClose()
    {
        int res = JOptionPane.OK_OPTION;

        if (getMediator().hasUnappliedChanges())
        {
            res = JOptionPane.showConfirmDialog(this, CHANGES, CHANGES_TITLE,
                     JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }

        return (res == JOptionPane.OK_OPTION);
    }

    public class MyQueryConverter extends QueryConverter {

        public MyQueryConverter(IConfigServer server, String type, String suffix) {
            super(server, type, suffix);
        }

        public MyQueryConverter(IConfigServer server, String type) {
            super(server, type);
        }

        @Override
        public Object viewValueToModel(Object viewValue) throws ViewValueConversionException {
            IConfigElement o = (IConfigElement) super.viewValueToModel(viewValue);
            if(o==null)
            {
                return o;
            }
            return o.getName();
        }

        @Override
        public Object modelValueToView(Object modelValue) throws ViewValueConversionException {
            if (modelValue == null)
            {
                return NONE;
            }

            if (modelValue instanceof String)
            {
                String name = (String) modelValue;

                name = stripDefaulSuffix(name);
                return ReferenceToStringConverter.convertToView(name);
            }
            throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
        }

        @Override
        public String[] getViewStringValues() {
            String[] viewStringValues = super.getViewStringValues();
            if(viewStringValues.length>1) {// more than None
                Arrays.sort(viewStringValues,1,viewStringValues.length);  // so that we preserve NONE at the head
            }
            return viewStringValues;
        }


        @Override
        public Class getModelClass() {
            return String.class;
        }

        public String getNone(){
            return NONE;
        }

        public String getDefaultDomain(){
            String[] viewStringValues = getViewStringValues();
            for (int i = 0; i < viewStringValues.length; i++) {
                String string = viewStringValues[i];
                if(!string.equals(NONE))
                {
                    return string;
                }
            }
            return NONE;
        }



    }

}