/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.plugin.ConfigFactoryInfo;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.RuntimeFactoryInfo;

public class ConfigDomainFolderModel
{
    protected IPluginContext     m_context;
    protected DomainConnectionModel m_model;

    public ConfigDomainFolderModel(IPluginContext context)
    {
        m_context = context;
        m_model   = context.getConnectionInfo();
    }

    public String getConnectionName()
    {
        return m_model.getConnectionName();
    }

    public String getDomainName()
    {
        return m_model.getDomainName();
    }

    public String getUrl()
    {
        return m_model.getUrl();
    }

    public String getUserName()
    {
        return m_model.getUserName();
    }

    public int getTimeout()
    {
        return m_model.getTimeout();
    }

    public String getManagementNode()
    {
        return m_model.getManagementNode();
    }

    public boolean isUsingManagement()
    {
        return m_model.isUseDRA();
    }

    public boolean isLoadBalancing()
    {
        return m_model.isLoadBalancing();
    }

    protected HashMap getFactoryMap()
    {
        return m_context.getLibrary().getConfigRootFactoryMap();
    }

    public List getPluginFactories()
    {
        ArrayList res  = new ArrayList();

        HashMap   map  = getFactoryMap();
        Iterator  iter = map.values().iterator();

        while (iter.hasNext())
        {
            ArrayList factories = (ArrayList)iter.next();

            for(int i = 0; i < factories.size(); i++)
            {
                Object factoryInfo = factories.get(i);

                if (factoryInfo instanceof ConfigFactoryInfo)
                {
                    res.add(((ConfigFactoryInfo)factoryInfo).getRootFactory());
                }
                else if (factoryInfo instanceof RuntimeFactoryInfo)
                {
                    res.add(((RuntimeFactoryInfo)factoryInfo).getRootFactory());
                }
            }
        }
        return res;
    }
}
