/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.config;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JOptionPane;

import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelValidationException;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.ImportPluginAction;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;

public class ConfigDomainFolderPlugin extends ConfigFolderPlugin
{
    public static final String PLUGIN_NAME = "Configured Objects";
    public static final String PLUGIN_TYPE = "ConfigDomain";
    public static final String DISPLAY_TYPE = PLUGIN_TYPE;


    private static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.TYPE, PLUGIN_TYPE},
        { PluginAttributes.IS_SYSTEM, "true" },
        { PluginAttributes.DISPLAY_TYPE, DISPLAY_TYPE}
    };

    private ConfigDomainFolderModel m_model = null;
    private ConfigDomainFolderDialog configDomainFolderDialog;

    public ConfigDomainFolderPlugin(IPluginContext context)
    {
        super(context, null, null);

        getAttributes().put(ATTRIBUTES);
    }

    @Override
    public String getPluginName()
    {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginPath()
    {
        return "/";
    }

    @Override
    public void dispose()
    {
        m_model = null;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        this.configDomainFolderDialog = new ConfigDomainFolderDialog(getPluginContext().getMgmtConsole());
        DomainFolderValidator validator = new DomainFolderValidator();
        configDomainFolderDialog.setValidator(validator);
        return configDomainFolderDialog;
    }

    @Override
    protected JComponent[] getSystemMenuItems()
    {
        JComponent[] items = new JComponent[]
        {
            new JBasicMenuItem(new ImportPluginAction(this)),
        };

        return Helper.combineMenu(items, super.getSystemMenuItems(), false);
    }

    @Override
    public Object getModel()
    {
        if (m_model == null) {
            m_model = new ConfigDomainFolderPluginModel(this, getPluginContext());
        }

        return m_model;
    }

    @Override
    public List getToolTipList()
    {
        DomainConnectionModel model = getPluginContext().getConnectionInfo();

        List list = new ArrayList();

        list.add(formatToolTipText("Connection", model.getConnectionName()));
        list.add(formatToolTipText("Domain",     model.getDomainName()));
        list.add(formatToolTipText("URL",        model.getUrl()));

        String userName = model.getUserName();
        if ((userName != null) && (userName.trim().length() > 0))
        {
            list.add(formatToolTipText("User Name", userName));
        }

        return list;
    }

    //-------------------------------------------------------------------------

    /*
    public boolean isDragSupported(int dropAction)
    {
        return false;
    }

    public boolean isDropSupported(int dropAction)
    {
        return true;
    }
    */

    @Override
    public void drop(IConfigPlugin dropPlugin, int dropAction)
    {
        try
        {
            /*
            // No need to call this here because the 'name' isn't changing...just
            // the location :)
            //dropPlugin.setName(name, false);
            String dragPath = dropPlugin.getViewPath();
            String dragName = dragPath.substring(dragPath.lastIndexOf('/') + 1);
            String dropPath = getViewPath();
            StringBuffer sbNewPath = new StringBuffer(dropPath);
            if (!dropPath.endsWith("/"))
            sbNewPath.append("/");
            sbNewPath.append(dragName);
            String newPath = sbNewPath.toString();
            */
        }
        catch (Exception e)
        {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
    }


    public class DomainFolderValidator implements ModelObjectValidator {
        public static final String REMOVE_PERMS_QSTN = "Are you sure you want to disable the use of Management Permissions?\n" +
                "All defined permissions will be reset.";
        public static final String CREATE_PERMS_QSTN = "Allow all access for the Administrators group?\n"+
                "(If you choose no, only the Administrator will have Management Permissions initially)";
        public static final String CHANGE_DOMAIN_QSTN ="Permissions checking will be temporarily disabled to establish the\n" +
                "new authentication domain and existing permissions will be removed. " +
                "\nDo you want to continue?";


        /**
         * <pre>
         * Three   cases.
         * 1) FGS <b>was</b> on & Authentication Domain(AD) was changed to a new AD
         *      a) Warn him that all perms will be removed.
         *      b) if OK, remove & fall through to 2
         *      c) if not OK, uset AD changes
         * 2) FGS was turned on.
         *      a) ask if default perms shud be enabled.
         *      b) if OK, enable default perms
         * 3) FGS has to be turned off
         *      a)  warn him that all perms will go away.
         *      b)  doesnt care. remove them
         *      c)  he does. rollback the AD change.
         * </pre>
         * @param modelObjectAdapter
         * @throws ModelValidationException
         */
        @Override
        public void validateModelEdit(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
            ConfigDomainFolderPluginModel model = (ConfigDomainFolderPluginModel) ConfigDomainFolderPlugin.this.m_model;
            if (model.getAuthenticationDomainChanged()) {  //  he has fiddled with authentication domain
                int res = JOptionPane.OK_OPTION;
                IDirectoryFileSystemService ds = ConfigDomainFolderPlugin.this.getPluginContext().getConnectionInfo().getDirectoryService();
                if (model.getSecurityEnabled()) {  // is enabled now.
                    if (model.wasSecurityEnabled()) { //  1. was  enabled, he changed to point to a new domain
                        res = JOptionPane.showConfirmDialog(configDomainFolderDialog, CHANGE_DOMAIN_QSTN, "Change Authentication Domain",
                                JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);  // 1.a Warn him that all perms will be removed.
                        if (res == JOptionPane.OK_OPTION) {  //1.b  yes. remove all existing permissions
                            try {
                                ((IManagementSecurityConfigurator) ds).removeAllManagementPermissions();
                            } catch (Exception e) {
                                String message = "Creation of default Management Permissions failed.";
                                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, message, e, false);
                                throw new ModelValidationException(e);
                            }
                        } else {  //  1.c  not OK, uset AD changes
                            model.unsetAuthenticationDomain();
                        }
                    }
                    if (res == JOptionPane.OK_OPTION) { // 2.  FGS  has to be turned on
                        res = JOptionPane.showConfirmDialog(configDomainFolderDialog, CREATE_PERMS_QSTN, "Administrators' Permissions",
                                JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);  // 2.a ask if def perms shud be enabled.
                        if (res == JOptionPane.OK_OPTION) {  // 2.b yes. ebale them
                            try {
                                ((IManagementSecurityConfigurator) ds).setDefaultManagementPermissions();
                            } catch (Exception e) {
                                String message = "Creation of default Management Permissions failed.";
                                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, message, e, false);
                                throw new ModelValidationException(e);
                            }
                        }
                    }
                } else { //  3. he has disabled it.
                    res = JOptionPane.showConfirmDialog(configDomainFolderDialog, REMOVE_PERMS_QSTN, "Disable Management Permissions",
                            JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE); // 3.a warn him that all perms will go away.
                    if (res == JOptionPane.OK_OPTION) {  // 3.b doesnt care. remove them
                        try {
                            ((IManagementSecurityConfigurator) ds).removeAllManagementPermissions();
                        } catch (Exception e) {
                            String message = "Removal of Management Permissions failed.";
                            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, message, e, false);
                            throw new ModelValidationException(e);
                        }
                    } else {  // 3.c he does. rollback JUST the authentication domain change.
                        model.unsetAuthenticationDomain();
                    }
                }
            }
            try {
                model.applyChanges();  // apply changes.
            } catch (Exception e) {
                String message = "Saving changes failed.";
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, message, e, false);
                throw new ModelValidationException(e);
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
        }

        @Override
        public void validateModelDeletion(ModelObjectAdapter modelObjectAdapter) throws ModelValidationException {
        }
    }
}