package com.sonicsw.ma.gui.config;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPluginContext;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;

public class ConfigDomainFolderPluginModel extends ConfigDomainFolderModel
{
    protected AbstractGUIPlugin m_plugin = null;

    public static final String PERMISSION_DENIED = "<Permission Denied>";

    public static final String AUTHENTICATION_DOMAIN = "AUTHENTICATION_DOMAIN";
    public static final String AUDIT_CONFIGURE_EVENTS = "AUDIT_CONFIGURE_EVENTS";
    public static final String AUDIT_MANAGE_EVENTS = "AUDIT_MANAGE_EVENTS";
    public static final String ENABLE_CENTRALIZED_AUDIT = "ENABLE_CENTRALIZED_AUDIT";
    public static final String DEFAULT_MANAGEMENT_AUDIT_CONFIG = "DEFAULT_MANAGEMENT_AUDIT_CONFIG";
    public static final String FORCE_CENTRALIZED_LOGGING = "FORCE_CENTRALIZED_LOGGING";
    public static final String CENTRALIZED_LOG_FILE = "CENTRALIZED_LOG_FILE";
    public static final String LOG_FILE_SIZE_THRESHOLD = "LOG_FILE_SIZE_THRESHOLD";
    public static final String LOG_FILE_ROLLOVER_SIZE_THRESHOLD = "LOG_FILE_ROLLOVER_SIZE_THRESHOLD";
    public static final String LOG_FILE_ROLLOVER_TIME_INTERVAL = "LOG_FILE_ROLLOVER_TIME_INTERVAL";

    private String authenticationDomain;
    private String originalDomain;  // to keep track of changes.
    private boolean auditConfigureEvents;
    private boolean auditManageEvents;
    private boolean enableCentralizedAudit;
    private String defautlManagementAuditConfig;
    private boolean enforeCentralizedLogging;
    private String centralizedLogFile;
    private long logFileSizeThreshold;
    private long logFileRolloverSizeThreshold;
    private int logFileRolloverTimeInterval;

    public ConfigDomainFolderPluginModel(AbstractGUIPlugin plugin, IPluginContext context)
    {
        super(context);
        m_plugin = plugin;
        initSecurityAndAuditSettings();
    }

    public final void initSecurityAndAuditSettings() {
        IDirectoryFileSystemService ds = m_plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        IDirElement domainElement = null;
        try {
            domainElement = ((IManagementSecurityConfigurator)ds).getDomainElement(false);
        } catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR,"Could not initialize Security & Audit settings",e,false);
            authenticationDomain = originalDomain = null;
            auditConfigureEvents = enableCentralizedAudit = false;
            defautlManagementAuditConfig = null;
            return;
        }
        IAttributeSet domainAttributes = domainElement.getAttributes();
        Reference authDomanRef = (Reference) domainAttributes.getAttribute(AUTHENTICATION_DOMAIN);
        if (authDomanRef == null || authDomanRef.getElementName() == null || authDomanRef.getElementName().length() == 0) {
            authenticationDomain = originalDomain = null;
        } else {
            try {
                authenticationDomain = originalDomain = ds.storageToLogical(authDomanRef.getElementName());
            } catch(com.sonicsw.mf.common.security.ConfigurePermissionDeniedException cpde)
            {
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR,"Configure permission (read) required for Authentication Domain",cpde,false);
                authenticationDomain = PERMISSION_DENIED;
            } catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR,"Could not initialize Security & Audit settings",e,false);
                authenticationDomain = originalDomain = null;
            }
        }
        
        Boolean booleanAttr = null;
        Long longAttr = null;
        Integer intAttr = null;

        booleanAttr = (Boolean) domainAttributes.getAttribute(AUDIT_CONFIGURE_EVENTS);
        auditConfigureEvents = booleanAttr == null ? false : booleanAttr.booleanValue();
        
        booleanAttr = (Boolean) domainAttributes.getAttribute(AUDIT_MANAGE_EVENTS);
        auditManageEvents = booleanAttr == null ? false : booleanAttr.booleanValue();
        
        booleanAttr = (Boolean) domainAttributes.getAttribute(ENABLE_CENTRALIZED_AUDIT);
        enableCentralizedAudit = booleanAttr == null ? false : booleanAttr.booleanValue();
        
        defautlManagementAuditConfig = (String) domainAttributes.getAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG);

        booleanAttr = (Boolean) domainAttributes.getAttribute(FORCE_CENTRALIZED_LOGGING);
        enforeCentralizedLogging = booleanAttr == null ? false : booleanAttr.booleanValue();

        centralizedLogFile = (String)domainAttributes.getAttribute(CENTRALIZED_LOG_FILE);

        longAttr = (Long)domainAttributes.getAttribute(LOG_FILE_SIZE_THRESHOLD);
        if(longAttr!=null)
        {
            logFileSizeThreshold = longAttr.longValue();
        }

        longAttr = (Long)domainAttributes.getAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD);
        if(longAttr!=null)
        {
            logFileRolloverSizeThreshold = longAttr.longValue();
        }

        intAttr = (Integer)domainAttributes.getAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL);
        if(intAttr!=null && (intAttr > 0 && intAttr <=1440))
        {
            logFileRolloverTimeInterval = intAttr.intValue();
        }
        else
        {
            logFileRolloverTimeInterval = 1440;
        }


    }

    /**
     * getPath - gets the containment path
     * @return path
     */
    public String getPath()
    {
        String strResult = m_plugin.getPluginPath();

        if (strResult != null)
        {
            int index = strResult.lastIndexOf("/");

            if (index != -1)
            {
                strResult = strResult.substring(0, index + 1);
            }
        }

        return strResult;
    }

    public boolean isSystem()
    {
        return (m_plugin != null) ? m_plugin.getAttributes().isSystem() : false;
    }

    public String getType()
    {
        return (m_plugin != null) ? m_plugin.getAttributes().getDisplayType() : "Unknown";
    }

    public void setSecurityEnabled(boolean enabled){
    }

    public boolean wasSecurityEnabled() {
        return originalDomain != null && originalDomain.trim().length()>0;
    }


    public boolean getSecurityEnabled(){
            return authenticationDomain != null && authenticationDomain.trim().length()>0;
    }

    public String getAuthenticationDomain() {
        return authenticationDomain;
    }

    public void setAuthenticationDomain(String authenticationDomain) {
        this.authenticationDomain = authenticationDomain;
    }

    public void unsetAuthenticationDomain() {
        this.authenticationDomain = originalDomain;
    }

    public boolean getAuthenticationDomainChanged(){
        return !String.valueOf(authenticationDomain).equals(String.valueOf(originalDomain));
    }

    public boolean isAuditConfigureEvents() {
        return auditConfigureEvents;
    }

    public void setAuditConfigureEvents(boolean auditConfigureEvents) {
        this.auditConfigureEvents = auditConfigureEvents;
    }

    public boolean isAuditManageEvents() {
        return auditManageEvents;
    }

    public void setAuditManageEvents(boolean auditManageEvents) {
        this.auditManageEvents = auditManageEvents;
    }

    public boolean isEnableCentralizedAudit() {
        return enableCentralizedAudit;
    }

    public void setEnableCentralizedAudit(boolean enableCentralizedAudit) {
        this.enableCentralizedAudit = enableCentralizedAudit;
    }

    public String getDefautlManagementAuditConfig() {
        return defautlManagementAuditConfig;
    }

    public void setDefautlManagementAuditConfig(String defautlManagementAuditConfig) {
        this.defautlManagementAuditConfig = defautlManagementAuditConfig;
    }

    public boolean isEnforeCentralizedLogging() {
        return enforeCentralizedLogging;
    }

    public void setEnforeCentralizedLogging(boolean enforeCentralizedLogging) {
        this.enforeCentralizedLogging = enforeCentralizedLogging;
    }

    public String getCentralizedLogFile() {
        return centralizedLogFile;
    }

    public void setCentralizedLogFile(String centralizedLogFile) {
        this.centralizedLogFile = centralizedLogFile;
    }

    public long getLogFileSizeThreshold() {
        return logFileSizeThreshold;
    }

    public void setLogFileSizeThreshold(long logFileSizeThreshold) {
        this.logFileSizeThreshold = logFileSizeThreshold;
    }

    public long getLogFileRolloverSizeThreshold() {
        return logFileRolloverSizeThreshold;
    }

    public void setLogFileRolloverSizeThreshold(long logFileRolloverSizeThreshold) {
        this.logFileRolloverSizeThreshold = logFileRolloverSizeThreshold;
    }
    public int getLogFileRolloverTimeInterval() {
        return logFileRolloverTimeInterval;
    }

    public void setLogFileRolloverTimeInterval(int logFileRolloverTimeInterval) {
        this.logFileRolloverTimeInterval = logFileRolloverTimeInterval;
    }



    public void applyChanges() throws ConfigException, ReadOnlyException, DirectoryServiceException {
        IDirectoryFileSystemService ds = m_plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        IDirElement domainElement = ((IManagementSecurityConfigurator)ds).getDomainElement(true);
        IAttributeSet domainAttributes = domainElement.getAttributes();
        domainAttributes.setBooleanAttribute(AUDIT_CONFIGURE_EVENTS, auditConfigureEvents ? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setBooleanAttribute(AUDIT_MANAGE_EVENTS, auditManageEvents ? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setBooleanAttribute(ENABLE_CENTRALIZED_AUDIT, enableCentralizedAudit ? Boolean.TRUE : Boolean.FALSE);

        if(authenticationDomain == null){
            domainAttributes.setReferenceAttribute(AUTHENTICATION_DOMAIN,null);
        }else{
            Reference domainRef = new Reference(ds.logicalToStorage(authenticationDomain));
            domainAttributes.setReferenceAttribute(AUTHENTICATION_DOMAIN,domainRef);
        }
        domainAttributes.setStringAttribute(DEFAULT_MANAGEMENT_AUDIT_CONFIG,defautlManagementAuditConfig);
        domainAttributes.setBooleanAttribute(FORCE_CENTRALIZED_LOGGING, enforeCentralizedLogging? Boolean.TRUE : Boolean.FALSE);
        domainAttributes.setStringAttribute(CENTRALIZED_LOG_FILE, centralizedLogFile);
        domainAttributes.setLongAttribute(LOG_FILE_SIZE_THRESHOLD, new Long(logFileSizeThreshold));
        domainAttributes.setLongAttribute(LOG_FILE_ROLLOVER_SIZE_THRESHOLD, new Long(logFileRolloverSizeThreshold));
        domainAttributes.setIntegerAttribute(LOG_FILE_ROLLOVER_TIME_INTERVAL, new Integer(logFileRolloverTimeInterval));
        IBasicElement updatedElement = domainElement.doneUpdate();
        ((IManagementSecurityConfigurator)ds).setDomainElement(((IDeltaDirElement) updatedElement));
        originalDomain = authenticationDomain;
    }

}