/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.config;

import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.table.ObjectColumn;
import com.sonicsw.ma.gui.table.PluginAttributesTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginContentPane;
import com.sonicsw.ma.gui.table.PluginCreatedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginModifiedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginSizeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginTypeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginVersionTableCellRenderer;
import com.sonicsw.ma.plugin.IPlugin;

public class ConfigFolderContentPane extends PluginContentPane
{
    public ConfigFolderContentPane(IPlugin plugin)
    {
        super(plugin);
    }
    
    @Override
    public TableColumn[] getColumns()
    {
        return new TableColumn[]
        {
            new ObjectColumn(0, "Name",          30, new PluginNameTableCellRenderer()).setDefaultVisible(true),
            new ObjectColumn(1, "Size",          20, new PluginSizeTableCellRenderer()).setDefaultVisible(true),
            new ObjectColumn(2, "Type",          30, new PluginTypeTableCellRenderer()).setDefaultVisible(true),
            new ObjectColumn(3, "Date Modified", 25, new PluginModifiedTableCellRenderer()).setDefaultVisible(true),
            new ObjectColumn(4, "Date Created",  25, new PluginCreatedTableCellRenderer()).setDefaultVisible(false),
            new ObjectColumn(5, "Attributes",    10, new PluginAttributesTableCellRenderer()).setDefaultVisible(false),
            new ObjectColumn(6, "Version",       15, new PluginVersionTableCellRenderer()).setDefaultVisible(false),
        };
    }
}
