/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import javax.swing.Action;
import javax.swing.JPanel;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMAFrame;

public class ConfigFolderDialog extends JPropSheetTabbedDialog
{
    public ConfigFolderDialog(JMAFrame parent)
    {
        this(parent, ConfigFolderModel.class);
    }

    protected ConfigFolderDialog(JMAFrame parent, Class modelClass)
    {
        super(parent, "folder", modelClass);
    }

    /**
     * Returns an array of button actions to use in the dialog.
     */
    @Override
    public Action[] getButtonActions()
    {
        return new Action[]
        {
            new CloseAction(getDefaultCancelAction()),
        };
    }

    /**
     * Overridden method to initialize the dialog GUI.
     */
    @Override
    public void initUI() throws Exception
    {
/*
        String generalTab = ResourceManager.getString(getClass(), "dialog.domain.tab.general.label");

        addTabPanel(generalTab,  JPartitionPanel.wrap(createGeneralPanel()));
*/
    }

    /**
     * Overridden method to initialize the data for the dialog GUI.
     */
    @Override
    public void initForm() throws Exception
    {
//        new JTextFieldAdapter(ModelAspectId.forName("connectionName"),  m_connectionName, EditRule.NEVER, null, getMediator());
    }

    private JPanel createGeneralPanel()
    {
        return new JPanel();
    }

    //-------------------------------------------------------------------------
    //
    // Inner Classes
    //
    //-------------------------------------------------------------------------

    /**
     * Class to override the normal Close action and behave as a Cancel action.
     */
    public class CloseAction extends BasicGuiAction
    {
        /**
         * Constructor to create the action.
         *
         * @param targetAction The action to use
         */
        public CloseAction(Action targetAction)
        {
            super("dialog.close", targetAction);
        }
    }

}
