/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import javax.swing.JLabel;

import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.AbstractPluginTreeCellRenderer;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;

public class ConfigPluginTreeCellRenderer extends AbstractPluginTreeCellRenderer
{
    @Override
    public void updateRenderer(JLabel label, AbstractGUIPlugin node)
    {
        IPlugin    plugin = (IPlugin)node;
        PluginAttributes attr   = plugin.getAttributes();

        if ((attr != null) && (attr.getType() != null))
        {
            label.setIcon(ResourceManager.getTypeIcon(plugin.getClass(), attr.getType()));
        }

        highlight((plugin instanceof IConfigPlugin) ? ((IConfigPlugin)plugin).isTemplatePrototype() : false);

        label.setText(plugin.getPluginName());
    }
}
