package com.sonicsw.ma.gui.config;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.IConfigServer;

public class DSFileChooser extends ComponentChooserDialog
{
    private JComboBox m_fileFilter;
    private String[]  m_filters = null;

    public DSFileChooser( JPropSheetDialog  parent,
                          String            name,
                          IPluginContext    context,
                          IConfigServer     server,
                          IPluginFilter     filter,
                          String[]          filters,
                          boolean           multiSelect)
    {
        super(parent, name, context, server, filter, multiSelect);
        m_filters = filters;
    }

    public DSFileChooser( JMAFrame       parent,
                          String         name,
                          IPluginContext context,
                          IConfigServer  server,
                          IPluginFilter  filter,
                          String[]          filters,
                          boolean        multiSelect)
    {
        super(parent, name, context, server, filter, multiSelect);
        m_filters = filters;
    }

    @Override
    public void initUI() throws Exception
    {
        super.initUI();

        addFieldsToGeneralPanel();

        m_fileFilter.addItemListener(new ItemListener()
        {
            @Override
            public void itemStateChanged(ItemEvent e)
            {
                if (e.getStateChange() == ItemEvent.SELECTED)
                {
                    String filter = (String)e.getItem();
                    ((FileElementFilter)getFilter()).setSelectedFilter(filter);
                    updateTree();
                }
            }
        });
    }

    private void addFieldsToGeneralPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", null, JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0);
        m_fileFilter = new JComboBox(new DefaultComboBoxModel(m_filters));
        panel.addRow("File filters", m_fileFilter);

        String filter = ((FileElementFilter)getFilter()).getSelectedFilter();

        m_fileFilter.getModel().setSelectedItem(filter);
        getGeneralPanel().add(panel);
    }
}