package com.sonicsw.ma.gui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.IElementIdentity;

/**
 * Simply filters out everything except MF_FILE
 * with the specified extentions, default is ".*"
 */

public class FileElementFilter implements IPluginFilter
{
    private static String DEFAULT_FILTER = "*.*";
    private String m_selectedFilter = DEFAULT_FILTER;


    @Override
    public boolean isPluginVisible(Object destination, Object pluginData)
    {
        try
        {
            HashMap map  = (HashMap)pluginData;
            String  name = (String)map.get(IConfigServer.FOLDER_NAME);

            if (name == null){
                try {
                name = (String)((IElementIdentity)map.get(IConfigServer.ELEMENT_IDENTITY)).getName();
                } catch (Exception e) {
                    String message = e.getMessage()==null?"Error filtering files.":e.getMessage();
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,message,e,false);
                    return false;
                }
            }

            name = name.substring(name.lastIndexOf('/') + 1);

            if (name.startsWith("_"))
            {
                return false;
            }


            String type    = (String)map.get(ConfigServerUtility.TYPE);
            String version = (String)map.get(ConfigServerUtility.CONFIG_VERSION);

            if (type == null)
            {
                if (!map.containsKey(IConfigServer.FOLDER_NAME))
                {
                    return false;
                }
            }
            else
            {
                if (!type.equals("MF_FILE"))
                {
                    return false;
                }

                // User can't add a template
                String templateType = (String)map.get(ConfigServerUtility.TEMPLATE_TYPE);
                if ((templateType != null) && templateType.equalsIgnoreCase(ConfigServerUtility.TEMPLATE_TYPE_PROTOTYPE))
                {
                    return false;
                }

               if (m_selectedFilter.equals(DEFAULT_FILTER))
            {
                return true;
            }

               if(!m_selectedFilter.equals(DEFAULT_FILTER) && !isValidExtension(name))
            {
                return false;
            }

            }
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Error filtering files.", e, true);
        }

        return true;
    }

    public void setSelectedFilter(String extention)
    {
        m_selectedFilter = extention;
    }

    public String getSelectedFilter()
    {
        return m_selectedFilter;
    }

    private String getExtension(String fileName)
    {
        String ext = null;

        int i = fileName.lastIndexOf('.');

        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private boolean isValidExtension(String name)
    {
        String ext = "*." + getExtension(name);
        StringTokenizer tn = new StringTokenizer(m_selectedFilter, ",");

        ArrayList exts = new ArrayList(0);

        while(tn.hasMoreTokens())
        {
            exts.add(tn.nextToken().trim());
        }

        if (exts.isEmpty())
        {
            exts.add(m_selectedFilter);
        }

        if(exts.contains(ext))
        {
            return true;
        }

        return false;
    }

}