/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.propsheets.IConfigPanel;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.propsheets.ClasspathPanel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSFileSystem;

import com.sonicsw.mf.common.archive.SonicArchive;

public class JClassesPanel extends JPartitionPanel implements IConfigPanel
{
    private static final IConfigPath ARCHIVE_NAME = ConfigFactory.createConfigPath("ARCHIVE_NAME");
    protected String archiveGroupTitle = "Archive";

    JTextField     m_archiveName = new JTextField();
    ClasspathPanel m_classpath   = null;
    
    
    public JClassesPanel()
    {
        this("");
    }

    public JClassesPanel(String borderTitle)
    {
        super(true, "p,r", borderTitle);
    }
    
    //------------------------------------------------------------------------
    //
    // IConfigPanel implementation
    //
    //------------------------------------------------------------------------

    @Override
    public String getTitle()
    {
        return "Resources";
    }
    
    @Override
    public JPanel getPanelComponent()
    {
        return this;
    }
    
    @Override
    public void initUI(JConfigDialog dialog)
    throws Exception
    {
        m_classpath = new ClasspathPanel(dialog);
        m_classpath.initUI();

        JPartitionPanel archivePanel = makeArchivePanel(dialog);
        //Defect: Sonic00025910 - in the 7.0 release this capability is not required.
        //archivePanel.addRow(dialog.getResourceLabel(ARCHIVE_NAME),  new JComponent[] { m_archiveName, new JBrowseButton(new ArchiveNameBrowseAction(dialog.getPlugin())) });
        add(archivePanel);

        JPanel pTmp = JPartitionPanel.merge("r", true, new JComponent[] { m_classpath });
        pTmp.setBorder(BorderFactory.createTitledBorder("Prepend Classpath"));
        add(pTmp);
    }

    protected JPartitionPanel makeArchivePanel(JConfigDialog dialog) {
        JPartitionPanel archivePanel = new JPartitionPanel(archiveGroupTitle);
        archivePanel.addRow(dialog.getResourceLabel(ARCHIVE_NAME),  new JComponent[] { m_archiveName });
        return archivePanel;
    }

    @Override
    public void initForm(JConfigDialog dialog)
    throws Exception
    {
        dialog.createJTextFieldAdapter(ARCHIVE_NAME, m_archiveName, null);

        m_classpath.initForm();
    }

    @Override
    public void cleanup()
    throws Exception
    {
    }

    //------------------------------------------------------------------------

    private class ArchiveNameBrowseAction extends BasicPluginAction
    {
        public ArchiveNameBrowseAction(IPlugin plugin)
        {
            super(plugin, "container.archive-name.browse");
            putNameValue();
        }

        private void putNameValue() {
            putValue(Action.NAME, "...");
        }
        
        @Override
        public void actionPerformed(ActionEvent evt)
        {
            String selectedFilter = "*.car";
            String[] m_filters = new String[] { selectedFilter, "*.*" };

            IPluginFilter filter = new FileElementFilter();

            JPropSheetDialog parentDialog = (JPropSheetDialog)Helper.getJDialog(JClassesPanel.this);
            
            ((FileElementFilter)filter).setSelectedFilter(selectedFilter);
            IConfigServer server = getPlugin().getPluginContext().getConfigContext().getConfigServer();
            JPropSheetDialog dialog = new DSFileChooser(parentDialog,
                                                        "archive.choose",
                                                        getPlugin().getPluginContext(),
                                                        server,
                                                        filter,
                                                        m_filters,
                                                        false);
            try
            {
                dialog.editInstance(getPlugin(), new HashMap(), false);
                dialog.setVisible(true);

                if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
                {
                    HashMap selList = (HashMap) dialog.getModel();

                    if ((selList != null) && !selList.isEmpty())
                    {
                        String carPath = (String)selList.keySet().iterator().next();
                        
                        System.out.println("CAR File: " + carPath);
                        
                        SonicFSFileSystem fs = new SonicFSFileSystem(getPlugin().getPluginContext().getConnectionInfo().getDirectoryService(),
                                                                     System.getProperty("user.name"));
                        File tmpFile = createTemporaryCarFile(fs.getContentBytes(carPath));
                            
                        m_archiveName.setText((new SonicArchive(tmpFile)).getName());
                    }
                }
            }
            catch (Exception e)
            {
                MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Failed to set archive name.", e, true);
            }
        }
            
        private File createTemporaryCarFile(byte[] content)
        {
            File resFile = null;
            BufferedOutputStream os = null;
        
            try
            {
                File tmpFile = File.createTempFile("SonicCarCheck", null);
                tmpFile.deleteOnExit();
                
                os = new BufferedOutputStream(new FileOutputStream(tmpFile));
                
                os.write(content);
                
                resFile = tmpFile;
            }
            catch (Exception e)
            {
                e.printStackTrace();
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
            }
            finally
            {
                if (os != null)
                {
                    try { 
                        os.close(); 
                    } catch (Exception e) { 
                        e.printStackTrace();
                        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                    }
                    
                    os = null;
                }
            }
            
            return resFile;
        }
    }
}    
