/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config;

import javax.swing.JPanel;
import javax.swing.JTextField;

import modelobjects.framework.IntToStringConverter;

import com.sonicsw.ma.gui.config.propsheets.IConfigPanel;
import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IConfigPath;


/**
 * <p>Title: JMetricsPanel.java</p>
 * <p>Description: UI panel that provides settable fields for the control
 *                 of a components (AGENT_MANAGER, CONTAINER (AGENT) or BROKER)
 *                 metric refresh and collection intervals.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author hjones
 * @version 1.0
 */
public class JMetricsPanel extends JPartitionPanel implements IConfigPanel
{
    public static final IConfigPath DEFAULT_PREFIX                      = ConfigFactory.createConfigPath("METRICS");
    public static final IConfigPath METRICS_REFRESH_INTERVAL_SECONDS    = ConfigFactory.createConfigPath("REFRESH_INTERVAL");
    public static final IConfigPath METRICS_COLLECTION_INTERVAL_MINUTES = ConfigFactory.createConfigPath("COLLECTION_INTERVAL");

    protected JPartitionPanel panel = null;
    private JTextField m_metricsRefreshInterval    = new JTextField();
    private JTextField m_metricsCollectionInterval = new JTextField();
    protected IConfigPath m_pathPrefix;
    private String      m_borderTitle = null;

    public JMetricsPanel()
    {
        this("", DEFAULT_PREFIX);
    }

    public JMetricsPanel(IConfigPath pathPrefix)
    {
        this("", pathPrefix);
    }

    public JMetricsPanel(String borderTitle)
    {
        this(borderTitle, DEFAULT_PREFIX);
    }

    public JMetricsPanel(String borderTitle, IConfigPath pathPrefix)
    {
        super(true, "p,r", null);

        m_pathPrefix = pathPrefix;
        m_borderTitle = borderTitle;
    }

    private IConfigPath getRefreshPath()
    {
        return ConfigFactory.createConfigPath(m_pathPrefix).append(METRICS_REFRESH_INTERVAL_SECONDS);
    }

    private IConfigPath getCollectionPath()
    {
        return ConfigFactory.createConfigPath(m_pathPrefix).append(METRICS_COLLECTION_INTERVAL_MINUTES);
    }

    //------------------------------------------------------------------------
    //
    // IConfigPanel implementation
    //
    //------------------------------------------------------------------------
    
    @Override
    public String getTitle()
    {
        return "Metrics";
    }
    
    @Override
    public JPanel getPanelComponent()
    {
        return this;
    }

    @Override
    public void initUI(JConfigDialog dialog)
    throws Exception
    {
        panel = new JPartitionPanel(m_borderTitle);
        panel.addRow(dialog.getResourceLabel(getRefreshPath()),    m_metricsRefreshInterval,    dialog.getResourceUnit("seconds"));
        panel.addRow(dialog.getResourceLabel(getCollectionPath()), m_metricsCollectionInterval, dialog.getResourceUnit("minutes"));
        add(panel);
    }

    @Override
    public void initForm(JConfigDialog dialog)
    throws Exception
    {
        dialog.createJTextFieldAdapter(getRefreshPath(),    m_metricsRefreshInterval,    new IntToStringConverter());
        dialog.createJTextFieldAdapter(getCollectionPath(), m_metricsCollectionInterval, new IntToStringConverter());
    }

    @Override
    public void cleanup()
    throws Exception
    {
    }

    //------------------------------------------------------------------------

}
