package com.sonicsw.ma.gui.config.metrics;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;

import com.sonicsw.mf.common.metrics.IMetricInfo;

/**
 * Created by IntelliJ IDEA.
 * User: schander
 * Date: Mar 12, 2009
 * Time: 6:04:02 PM
 * To change this template use File | Settings | File Templates.
 */
public class AlertsDialog extends JMADialog {

    private MetricsModel m_metricsModel;
    private AbstractNode m_node;

    protected JPanel m_panel;
    private JTextField m_highThresholds;
    private JTextField m_lowThresholds;

    private JTextField m_parentHighThresholds;
    private JTextField m_parentLowThresholds;

    private AlertsModel m_alertsModel;
    private AlertsModel m_parentAlertsModel;

//    private JButton m_okButton = new JButton(new OKAction());

    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];

    public AlertsDialog(JMADialog parent, MetricsModel metricsModel, AbstractNode node) {
        super(parent, "metrics.alerts.setting");

        m_metricsModel = metricsModel;
        m_node = node;
        setTitle();
        m_alertsModel = ((IAlertsProvider)node).getAlertsModel();
    }
    
    private void setTitle() {
        setTitle(getTitle() + " - " + m_metricsModel.getComponentName().toString());
    }

    @Override
    protected void maInitialize() {
        getContentPane().add(JPartitionPanel.wrap(makeMainPanel()));

        m_highThresholds.setText(thresholdsListToThresholdsString(m_alertsModel.getHighThresholdValues()));
        m_lowThresholds.setText(thresholdsListToThresholdsString(m_alertsModel.getLowThresholdValues()));

        if (m_parentAlertsModel != null)
        {
            m_parentHighThresholds.setText(thresholdsListToThresholdsString(m_parentAlertsModel.getHighThresholdValues()));
            m_parentLowThresholds.setText(thresholdsListToThresholdsString(m_parentAlertsModel.getLowThresholdValues()));
        }
    }
    @Override
    public Action[] getButtonActions()
    {
        List list = new ArrayList();

        list.add(new OKAction());
        list.add(getDefaultCancelAction());

        return (Action[])list.toArray(new Action[list.size()]);
    }

    @Override
    protected void maCleanup() {
        m_metricsModel = null;
        m_node = null;
    }

    private class OKAction extends BasicGuiAction
    {
        public OKAction() { super("dialog.ok", AlertsDialog.this.getDefaultOKAction()); }
        @Override
        public void actionPerformed(ActionEvent evt)
        {
            try
            {
                AlertsDialog.this.updateAlerts();
                super.actionPerformed(evt);
            }
            catch(Exception e)
            {
                MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, e.getMessage(), e, true);
            }

        }
    }

    private JPanel makeMainPanel()
    {
        IMetricInfo info = (IMetricInfo)(m_node instanceof InstanceNode ? ((InstanceParentNode)m_node.getParent()).getUserObject() : m_node.getUserObject());

        m_highThresholds = new JTextField(30);
        if (!info.supportsHighThresholdAlerts())
        {
            m_highThresholds.setEditable(false);
        }
        m_lowThresholds = new JTextField(30);
        if (!info.supportsLowThresholdAlerts())
        {
            m_lowThresholds.setEditable(false);
        }

        if (m_parentAlertsModel != null)
        {
            m_parentHighThresholds = new JTextField(30);
            m_parentHighThresholds.setEditable(false);
            m_parentLowThresholds = new JTextField(30);
            m_parentLowThresholds.setEditable(false);
        }

        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "Comma-delimited Threshold(s)");

        panel.addRow("High Threshold(s)", m_highThresholds);
        if (m_parentAlertsModel != null)
        {
            panel.addRow("Parent High Threshold(s)", m_parentHighThresholds);
        }

        panel.addRow("Low Threshold(s)", m_lowThresholds);
        if (m_parentAlertsModel != null)
        {
            panel.addRow("Parent Low Threshold(s)", m_parentLowThresholds);
        }

        return panel;
    }
    private String thresholdsListToThresholdsString(List data)
    {
        Collections.sort(data);
        StringBuffer values = new StringBuffer("");
        if (data == null)
        {
            return values.toString();
        }
        for(int i = 0; i < data.size(); i++)
        {
          values.append(data.get(i)).append(",");
        }
        String result = values.toString();
        return (result.length() == 0) ? result : result.substring(0, result.length() - 1);
    }

    private ArrayList thresholdsStringToThresholdsList(String data)
    throws Exception
    {
        ArrayList list = new ArrayList();

        StringTokenizer st = new StringTokenizer(data, ", ");
        while (st.hasMoreTokens())
        {
            String value = st.nextToken();
            try
            {
                list.add(Long.valueOf(value));
            }
            catch(NumberFormatException e)
            {
                throw new Exception("Invalid threshold value: " + value);
            }
        }

        return list;
    }

    private void updateAlerts()
    throws Exception
    {
        ArrayList highThresholds = null;
        ArrayList lowThresholds = null;
        ArrayList highThresholdsDelta = null;
        ArrayList lowThresholdsDelta = null;

        Long[] existingHighThresholds = (Long[])m_alertsModel.getHighThresholdValues().toArray(EMPTY_LONG_ARRAY);
        Long[] existingLowThresholds = (Long[])m_alertsModel.getLowThresholdValues().toArray(EMPTY_LONG_ARRAY);

        highThresholds = m_highThresholds.isEnabled() ? thresholdsStringToThresholdsList(m_highThresholds.getText()) : new ArrayList();
        lowThresholds = m_lowThresholds.isEnabled() ? thresholdsStringToThresholdsList(m_lowThresholds.getText()) : new ArrayList();

        // work out if any alerts have been disabled
        highThresholdsDelta = new ArrayList();
        if (m_highThresholds.isEnabled())
        {
            for (int i = 0; i < existingHighThresholds.length; i++)
            {
                if (!highThresholds.contains(existingHighThresholds[i]))
                {
                    highThresholdsDelta.add(existingHighThresholds[i]);
                }
            }
        }
        lowThresholdsDelta = new ArrayList();
        if (m_lowThresholds.isEnabled())
        {
            for (int i = 0; i < existingLowThresholds.length; i++)
            {
                if (!lowThresholds.contains(existingLowThresholds[i]))
                {
                    lowThresholdsDelta.add(existingLowThresholds[i]);
                }
            }
        }

        // if so update
        if (!highThresholdsDelta.isEmpty() || !lowThresholdsDelta.isEmpty())
        {
            m_metricsModel.disableAlerts(m_node, (Long[])highThresholdsDelta.toArray(EMPTY_LONG_ARRAY), (Long[])lowThresholdsDelta.toArray(EMPTY_LONG_ARRAY));
        }

        // work out if any alerts have been enabled
        if (m_highThresholds.isEnabled())
        {
            for (int i = 0; i < existingHighThresholds.length; i++)
            {
                highThresholds.remove(existingHighThresholds[i]);
            }
            highThresholdsDelta = highThresholds;
        }
        else
        {
            highThresholdsDelta = new ArrayList();
        }
        if (m_lowThresholds.isEnabled())
        {
            for (int i = 0; i < existingLowThresholds.length; i++)
            {
                lowThresholds.remove(existingLowThresholds[i]);
            }
            lowThresholdsDelta = lowThresholds;
        }
        else
        {
            lowThresholdsDelta = new ArrayList();
        }

        // if so update
        if (!highThresholdsDelta.isEmpty() || !lowThresholdsDelta.isEmpty())
        {
            m_metricsModel.enableAlerts(m_node, (Long[])highThresholdsDelta.toArray(EMPTY_LONG_ARRAY), (Long[])lowThresholdsDelta.toArray(EMPTY_LONG_ARRAY));
        }
    }


}
