package com.sonicsw.ma.gui.config.metrics;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.sonicsw.ma.gui.config.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPlugin;

final class InstancePickSheet
    extends JMADialog
{
    private static final String SYSTEM_INSTANCE = "sonicmq.";
    private static final String TYPE_BROKER = "MQ_BROKER";
    private static final String TEMP_INSTANCE = "$ISYS.USERS.TemporaryQueues";

//    private JRowTable m_table;
    private JTextField m_tfPattern = new JTextField();
    private JRadioButton m_btnPattern = new JRadioButton("<html>By defining a pattern that matches one or more instances</html>");
    private JRadioButton m_btnAll = new JRadioButton("<html>Enable all instance pattern metrics of this type</html>");
//    private JRadioButton m_btnInstance = new JRadioButton("<html>Pick instance(s) that currently exist on the component...</html>");
//    private JCheckBox m_showSystem = new JCheckBox("<html>Show System Instance<html>");
//    private JCheckBox m_showTemp = new JCheckBox("<html>Show Temporary Queue Instances<html>");
    private MetricsModel m_model;


    public InstancePickSheet(JMADialog parent, MetricsModel m_model)
    {
        super(parent, "metrics.pattern.pick");
        this.m_model=m_model;
    }

    private com.sonicsw.ma.gui.config.metrics.InstanceEnablementSheet getEnablementSheet()
    {
        return (com.sonicsw.ma.gui.config.metrics.InstanceEnablementSheet) getParent();
    }

    @Override
    public void maInitialize()
    {
        getContentPane().add(makePanel());

//        refreshInstances();
    }

    @Override
    public void maCleanup()
    {
//        if (m_table != null)
//        {
//            m_table.cleanup();
//        }
    }

    @Override
    public Action[] getButtonActions()
    {
        return new Action[]
            {
            new OKAction(), getDefaultCancelAction()};
    }

//    private void refreshInstances()
//    {
//        String[] iNames = getEnablementSheet().getInstances();
////        IModelTableModel tableModel = (IModelTableModel) m_table.getModel();
//
////        tableModel.clear();
////         boolean isTemp = false;
////         boolean isSystem = false;
////        boolean canAdd = false;
//        for (int i = 0; i < iNames.length; i++)
//        {
//            String instanceName = iNames[i];
//
////            isTemp = instanceName.startsWith(TEMP_INSTANCE);
////            isSystem = instanceName.toLowerCase().startsWith(SYSTEM_INSTANCE);
////            canAdd = false;
////            if(isSystem ){
////                if(m_showSystem.isSelected())
////                    canAdd=true;
////
////            }else if(isTemp){
////                if((isValidSource()) && (m_showTemp.isSelected()))
////                    canAdd=true;
////
////            }else{
////                canAdd=true;
////            }
////
////            if(canAdd)
//            tableModel.addRow(instanceName);
//        }
//    }

    private JPanel makePanel()
    {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(m_btnAll);
        btnGroup.add(m_btnPattern);
//        btnGroup.add(m_btnInstance);

        m_btnAll.setVerticalTextPosition(SwingConstants.TOP);
        m_btnPattern.setVerticalTextPosition(SwingConstants.TOP);
//        m_btnInstance.setVerticalTextPosition(SwingConstants.TOP);

//        m_table = new JRowTable(new RowTableColumn[]
//                                {new RowTableColumn(0, "Instance Name", 100)}
//                                , getClass().getName());

        JPartitionPanel panel = new JPartitionPanel(true, "p,p,p,r", null, JPartitionPanel.DEFAULT_GAP_SIZE, 5, 5);

        panel.setBorder(panel.getPreferredBorder());
        panel.add(new JLabel("Add an instance pattern:"));
        panel.add(makeAllPanel());
        panel.add(makePatternPanel());
//        panel.add(makeInstancePanel());

        m_tfPattern.addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(FocusEvent evt)
            {
                m_btnPattern.setSelected(true);
                enableButtons();
            }
        });
//        m_table.addFocusListener(new FocusAdapter()
//        {
//            public void focusGained(FocusEvent evt)
//            {
////                m_btnInstance.setSelected(true);
//                enableButtons();
//            }
//        });

        ChangeListener cl = new ChangeListener()
        {
            @Override
            public void stateChanged(ChangeEvent evt)
            {
                enableButtons();
            }
        };
        m_btnPattern.addChangeListener(cl);
        m_btnAll.addChangeListener(cl);
        m_btnAll.setSelected(true);
//        m_btnInstance.addChangeListener(cl);
        m_tfPattern.getDocument().addDocumentListener(new DocumentListener()
        {
            @Override
            public void changedUpdate(DocumentEvent evt)
            {
                enableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent evt)
            {
                enableButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent evt)
            {
                enableButtons();
            }
        });
//        m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener()
//        {
//            public void valueChanged(ListSelectionEvent evt)
//            {
//                enableButtons();
//            }
//        });
//        m_table.addMouseListener(new MouseAdapter()
//        {
//            public void mouseClicked(MouseEvent evt)
//            {
//                if (evt.getClickCount() == 2)
//                    getOKButton().doClick();
//            }
//        });

        return panel;
    }

    private JPanel makeAllPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "r", null, 0, 0, 0);

        panel.add(m_btnAll);

        return panel;
    }

    private JPanel makePatternPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(true, "r,r", null, 0, 0, 0);

        JPartitionPanel insetPanel = new JPartitionPanel(false, "p,p,r", null);

        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel());
        insetPanel.add(new JLabel("e.g. Sample*"));
        insetPanel.add(new JPanel());
        insetPanel.add(new JLabel("Pattern: "));
        insetPanel.add(m_tfPattern);

        panel.add(m_btnPattern);
        panel.add(insetPanel);

        return panel;
    }

//    private JPanel makeInstancePanel()
//    {
//        JPartitionPanel panel = new JPartitionPanel(true, "p,r", null);
//
//        JPartitionPanel tablePanel = new JPartitionPanel(true, "r,p", null, JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0);
//
//        JButton btnRefresh = new JButton("Refresh");
//        btnRefresh.addActionListener(new ActionListener()
//        {
//            public void actionPerformed(ActionEvent evt)
//            {
//                refreshInstances();
//            }
//        });
//
////        m_showSystem.addItemListener(new ItemListener()
////        {
////            public void itemStateChanged(ItemEvent evt)
////            {
////                IModelTableModel model = (IModelTableModel) m_table.getModel();
////
////                if (evt.getStateChange() == ItemEvent.DESELECTED)
////                {
////                    for (int i = model.getRowCount() - 1; i >= 0; i--)
////                    {
////                        String row = (String) model.getRowModel(i);
////
////                        if (row.toLowerCase().startsWith(SYSTEM_INSTANCE))
////                            model.deleteRow(i);
////                    }
////                }
////                else
////                {
////                    refreshInstances();
////                }
////            }
////        });
//        JPartitionPanel btnPanel = new JPartitionPanel(false, "p,p", null, JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0);
////        btnPanel.add(m_showSystem);
//
////        if (isValidSource())
////        {
////            m_showTemp.addItemListener(new ItemListener() {
////                public void itemStateChanged(ItemEvent evt) {
////                    IModelTableModel model = (IModelTableModel) m_table.getModel();
////
////                    if (evt.getStateChange() == ItemEvent.DESELECTED) {
////                        for (int i = model.getRowCount() - 1; i >= 0; i--) {
////                            String row = (String) model.getRowModel(i);
////
////                            if (row.startsWith(TEMP_INSTANCE))
////                                model.deleteRow(i);
////                        }
////                    } else {
////                        refreshInstances();
////                    }
////                }
////            });
////            btnPanel.add(m_showTemp);
////        }
//        btnPanel.add(btnRefresh);
//        btnPanel.add(new JPanel());
//
////        btnPanel.add(JPartitionPanel.merge("p,r", false, 0, 0, 0, new Component[]{btnRefresh,new JPanel()}));
//
////        JPartitionPanel comp = JPartitionPanel.merge("p,p", true, 0, 0, 0, new Component[]{m_showSystem, m_showTemp});
//
////        btnPanel.add(JPartitionPanel.merge("p,p,p", false, 0, 0, 0, new Component[]{comp,new JPanel(),btnRefresh}));
//
//        tablePanel.add(new ExtendedJScrollPane(m_table));
//        tablePanel.add(btnPanel);
//
//        JPartitionPanel insetPanel = new JPartitionPanel(false, "p,r", "Instances", JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0);
//        insetPanel.add(new JPanel());
//        insetPanel.add(tablePanel);
//
////        panel.add(m_btnInstance);
//        panel.add(insetPanel);
//
//        return panel;
//    }

    private boolean isValidSource() {
        String type = "";
        if(m_model.getSource() instanceof IPlugin){
            IPlugin plugin = (IPlugin) m_model.getSource();
            type = plugin.getAttributes().getType();
        }
        return  TYPE_BROKER.equals(type);
    }

    private void enableButtons()
    {
        boolean enable = false;

        if (m_btnPattern.isSelected())
        {
            enable = (m_tfPattern.getText().trim().length() > 0);
        }
        else
        if (m_btnAll.isSelected())
         {
            enable = true;
//        else
//        if (m_btnInstance.isSelected())
//            enable = (m_table.getSelectedRow() != -1);
        }

        getOKButton().setEnabled(enable);
    }

    private JButton getOKButton()
    {
        return ((JButtonPanel) getButtonPanel()).getButton("dialog.ok");
    }

    private class OKAction
        extends BasicGuiAction
    {
        public OKAction()
        {
            super("dialog.ok", getDefaultOKAction());
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            String[] value = null;

            if (m_btnPattern.isSelected())
            {
                value = new String[]
                        {m_tfPattern.getText().trim()};
            }
            else
            if (m_btnAll.isSelected())
             {
                value = new String[]
                        {"*"};
//            else
//            if (m_btnInstance.isSelected())
//            {
//                IModelTableModel tableModel = (IModelTableModel) m_table.getModel();
//                int[] sel = m_table.getSelectedRows();
//                ArrayList selList = new ArrayList();
//
//                for (int i = 0; i < sel.length; i++)
//                    selList.add(tableModel.getRowModel(sel[i]));
//
//                value = (String[]) selList.toArray(new String[selList.size()]);
//            }
            }

            if (value != null)
            {
                getEnablementSheet().addPattern(value);
            }

            super.actionPerformed(evt);
        }
    }
}