package com.sonicsw.ma.gui.config.metrics.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.management.ObjectName;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueListener;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.metrics.model.ParentNode;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.plugin.IConfigMetricPlugin;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.mx.util.Sorter;

import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;


/**
 * Created by IntelliJ IDEA.
 * User: schander
 * Date: Mar 10, 2009
 * Time: 4:44:19 PM
 * To change this template use File | Settings | File Templates.
 */
public class MetricsModel extends AbstractMetricsModel {

    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];
    public static final int DISABLE_INSTANCE_NONE     = 0;
    public static final int DISABLE_INSTANCE_ALL      = 1;
    public static final int DISABLE_INSTANCE_WILDCARD = 2;

    private boolean m_hasMetricAlertsSupport = false;
    private boolean m_hasInstanceMetrics     = false;

    private IMonitorPlugin source = null;
    public MetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos) throws Exception {
        super(connector, componentName, infos);
        update(infos);
    }

    @Override
    public final void update(IMetricInfo[] info)
    {
        Sorter.sort(info, this, info.length);
        Enumeration en = m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements())
        {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node == m_treeRootNode)
            {
                continue;
            }

            String name = null;
            if ((node instanceof Node) || (node instanceof InstanceParentNode))
            {
                name = ((IMetricInfo)node.getUserObject()).getMetricIdentity().getName();
            }
            else
            {
                name = ((IMetricIdentity)node.getUserObject()).getName();
            }

            if (!inList(info, name))
            {
                try
                {
                    disableMetric(node);
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                }
            }
        }

        constructTree(info);
    }
    private boolean inList(IMetricInfo[] list, String metricName)
    {
        boolean found = false;

        for (int i = 0; i < list.length; i++)
        {
            if (list[i].getMetricIdentity().getName().startsWith(metricName))
            {
                found = true;
                break;
            }
        }

        return found;
    }

    public Object getSource() {
        return source;
    }

    public void setSource(IMonitorPlugin source) {
        this.source = source;
    }

    

    public void enableMetric(AbstractNode node)
    throws Exception
    {
        HashSet ids = new HashSet();
        setIdentities(node, ids, true,DISABLE_INSTANCE_NONE);
        IMetricIdentity[] metricIds = (IMetricIdentity[])ids.toArray(new IMetricIdentity[ids.size()]);

        ((IConfigMetricPlugin)source).updateMetrics(true,metricIds);
        refreshTree();
        node.setEnabled(true);
        node.setParentEnabled();

        // call nodeChanged for the parents
        AbstractNode changeNode = node;
        while (changeNode != m_treeRootNode)
        {
            super.nodeChanged(changeNode);
            changeNode = (AbstractNode)changeNode.getParent();
        }
        // call nodeChanged for the children
        Enumeration en = node.depthFirstEnumeration();
        while (en.hasMoreElements())
        {
            AbstractNode descendant = (AbstractNode)en.nextElement();
            super.nodeChanged(descendant);
        }
        super.nodeChanged(node);
    }


    private void setLeafNodeStates(AbstractNode node, HashSet enabledExactPatterns, HashSet activeMetrics, HashMap enabledAlertsSets)
    {
        // NOTE: remove handled enabled metrics as we go so that any iterating gets more
        //       efficient as we continue
        if (node instanceof Node) // simple enable/disable
        {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            boolean enabled = activeMetrics.remove(metricId);
            ((Node)node).setEnabled(enabled);
            addAlerts(node, metricId, enabledAlertsSets);
        }
        else
        if (node instanceof ParentNode) // walk the children
        {
            Enumeration en = ((ParentNode)node).children();
            while (en.hasMoreElements())
            {
                setLeafNodeStates((AbstractNode)en.nextElement(),enabledExactPatterns, activeMetrics, enabledAlertsSets);
            }
        }
        else
        if (node instanceof InstanceNode) // remove it if it is no longer enabled
        {
            if (!(activeMetrics.remove(node.getUserObject()) || enabledExactPatterns.remove(node.getUserObject())))
            {
                node.removeFromParent();
            }
        }
        else
        if (node instanceof InstanceParentNode) // are there any new instances that must be created under it
        {
            node.removeAllChildren();
            IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            addAlerts(node, parentId, enabledAlertsSets);

            HashMap children = new HashMap();

            buildInstanceNodes(node, parentId, children, enabledExactPatterns, false);
            buildInstanceNodes(node, parentId, children, activeMetrics, true);

//             if there are children then add them in
            if (!children.isEmpty())
            {
//                // resort then add back in
                Object[] nodes = Sorter.sort(children.values().toArray(), this, children.size());
                for (int i = 0; i < nodes.length; i++)
                {
                    IMetricIdentity metricId = (IMetricIdentity) ((InstanceNode) nodes[i]).getUserObject();
                    node.add((InstanceNode)nodes[i]);
                    addAlerts((InstanceNode)nodes[i], metricId, enabledAlertsSets);
                }
                node.setEnabled(true);
                node.setParentEnabled();
            }

            this.nodeStructureChanged(node);
        }
    }

    private void  buildInstanceNodes(AbstractNode parentNode, IMetricIdentity parent, HashMap children, Set ids, boolean enabled)
    {
        IMetricIdentity[] metricsIds = (IMetricIdentity[])ids.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        boolean hasWildCard = false;
        for (int i = 0; i < metricsIds.length; i++)
        {
            if (metricsIds[i].isInstanceOf(parent)) {
                if(containsWildcard(metricsIds[i])){
                    parentNode.setEnabled(true);
                    parentNode.setParentEnabled();
                    hasWildCard = true;
                }  else {
                    /* Non wild-card match */
                    ids.remove(metricsIds[i]); // since weve now handled this
                    String[] nameComponents = metricsIds[i].getNameComponents();
                    InstanceNode newChild = new InstanceNode(metricsIds[i], nameComponents[nameComponents.length - 1]);
                    newChild.setEnabled(enabled);
                    newChild.setParentEnabled();
                    children.put(metricsIds[i], newChild);
                    
                }
            }
        }
        if(hasWildCard || !children.isEmpty()){
            parentNode.setEnabled(true);
        }else{
            parentNode.setEnabled(false);
        }
        parentNode.setParentEnabled();
    }

    private boolean containsWildcard(IMetricIdentity metricID)
    {
    	String wildcard = "*";
    	String metricName = metricID.getAbsoluteName();
    	int index = metricName.indexOf(wildcard);
    	if (index == -1) {
    		return false;
    	}

    	String[] nameComponents = metricID.getNameComponents();
    	if (!"queue".equals(nameComponents[0])) {
    		return true;
    	}

        if(metricName.indexOf("%.*%.*")>0){
            String modifiedStr = metricName.replaceAll("%\\.\\*%\\.\\*", "_");
            index = modifiedStr.indexOf(wildcard);
        }
        return (index != -1);
    }

    private void addAlerts(AbstractNode node, IMetricIdentity metricId, HashMap enabledAlertsSets)
    {
        if (node instanceof IAlertsProvider)
        {
            HashSet alerts = (HashSet)enabledAlertsSets.remove(metricId);
            if (alerts != null){
                AlertsModel alertsModel = ((IAlertsProvider) node).getAlertsModel();
                ((IAlertsProvider)node).getAlertsModel().setAlerts(alerts);
            }else{
                AlertsModel alertsModel = ((IAlertsProvider) node).getAlertsModel();
                if(alertsModel!=null)
                {
                    alertsModel.setAlerts(null);
                }
            }
        }
    }
        /**
     * Construct the metrics node tree from the metrics info and enabled metrics list
     * obtained from the component.
     */
    private void constructTree(IMetricInfo[] infos)
    {
        m_hasMetricAlertsSupport = false;
        m_hasInstanceMetrics = false;

        for (int i = 0; i < infos.length; i++)
        {
            AbstractParentNode parent = m_treeRootNode;
            String[] nameTokens = infos[i].getMetricIdentity().getNameComponents();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; j++)
            {
                if (j == nameTokens.length - 1)
                {
                    boolean isInstanceMetric = infos[i].isInstanceMetric();
                    if (isInstanceMetric)
                    {
                        m_hasInstanceMetrics = true;
                    }

                    if (infos[i].supportsHighThresholdAlerts() || infos[i].supportsLowThresholdAlerts())
                    {
                        m_hasMetricAlertsSupport = true;
                    }

                    if (parent.getChild(nameTokens[j]) == null)
                    {
                        parent.add(isInstanceMetric ? (AbstractNode)new InstanceParentNode(infos[i], nameTokens[j])
                                                    : (AbstractNode)new Node(infos[i], nameTokens[j]));
                    }
                }
                else
                {
                    if (j > 0)
                    {
                        prefix.append('.');
                    }
                    prefix.append(nameTokens[j]);
                    AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                    if (childNode == null)
                    {
                        childNode = new ParentNode(MetricsFactory.createMetricIdentity(prefix.toString()), nameTokens[j]);
                        parent.add(childNode);
                    }
                    parent = childNode;
                }
            }
        }
    }

    @Override
    public void refreshTree() throws Exception {
        Object[] values =null;
        IMetricIdentity[] activeMetrics = new IMetricIdentity[0];
        IAlert[] enabledAlerts = new IAlert[0];


        values = ((IConfigMetricPlugin)source).getMetricAndAlertInfo();
        if(values != null){
            if(values[0] != null)
            {
                activeMetrics = (IMetricIdentity[]) values[0];
            }
            if(values[1] != null)
            {
                enabledAlerts = (IAlert[]) values[1];
            }
        }

        HashSet enabledExactPatternsSet = new HashSet();
        for (int i = 0; i < activeMetrics.length; i++)
        {
            // filter those with wildcards, since we don't want a node for them
//            if (activeMetrics[i].getName().indexOf('*') == -1)
                enabledExactPatternsSet.add(activeMetrics[i]);
        }

        HashSet activeMetricsSet = new HashSet(activeMetrics.length);
        for (int i = 0; i < activeMetrics.length; i++)
        {
            activeMetricsSet.add(activeMetrics[i]);
        }

        // put the alerts in a table for later use
        HashMap enabledAlertsSets = new HashMap();
        for (int i = 0; i < enabledAlerts.length; i++)
        {
            HashSet alerts = (HashSet)enabledAlertsSets.get(enabledAlerts[i].getMetricIdentity());
            if (alerts == null)
            {
                alerts = new HashSet();
                enabledAlertsSets.put(enabledAlerts[i].getMetricIdentity(), alerts);
            }
            alerts.add(enabledAlerts[i]);
        }



        setLeafNodeStates(m_treeRootNode,enabledExactPatternsSet, activeMetricsSet, enabledAlertsSets);

        Enumeration en = m_treeRootNode.depthFirstEnumeration();
        ParentNode lastParentNode = null;
        while (en.hasMoreElements())
        {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node instanceof Node) // look at parent enablement
            {
                ParentNode parent = (ParentNode)node.getParent();
                if (parent != null && parent != lastParentNode)
                {
                    lastParentNode = parent;
                    node.setParentEnabled();
                }
            }
        }
    }


    public void disableMetric(AbstractNode node)
    throws Exception
    {
        disableMetric(node, DISABLE_INSTANCE_ALL);
    }

    public void disableMetric(AbstractNode node, int instanceDisableMode)
        throws Exception
        {
            HashSet ids = new HashSet();
            setIdentities(node, ids, false, instanceDisableMode);
            IMetricIdentity[] metricIds = (IMetricIdentity[])ids.toArray(new IMetricIdentity[ids.size()]);

            ((IConfigMetricPlugin)source).updateMetrics(false,metricIds);
//            removeAlertWhenMetricsDisabled(node);
            if (node instanceof InstanceNode)
            {
                InstanceParentNode parent = (InstanceParentNode)node.getParent();
                removeAlertWhenMetricsDisabled(parent);
                parent.remove(node);
                super.nodeStructureChanged(parent);
            }
            else
            if (node instanceof InstanceParentNode)
            {
                disableAlertsWhenMetricsDisabled(metricIds, node);
                node.removeAllChildren();
                refreshTree();
                super.nodeStructureChanged(node);

            }
            else
            if (node instanceof ParentNode)
            {
                ArrayList instanceParents = new ArrayList();
                Enumeration en = node.depthFirstEnumeration();
                while (en.hasMoreElements())
                {
                    AbstractNode descendant = (AbstractNode)en.nextElement();
                    if (descendant instanceof InstanceParentNode)
                    {
                        instanceParents.add(descendant);
                    }
                }
                for (int i = instanceParents.size() - 1; i >= 0; i--)
                {
                    ((InstanceParentNode)instanceParents.get(i)).removeAllChildren();
                    super.nodeStructureChanged((InstanceParentNode)instanceParents.get(i));
                }
                refreshTree();
                super.nodeChanged(node);
            }

            node.setEnabled(false);
            refreshTree();
            node.setParentEnabled();
//            disableAlertsWhenMetricsDisabled(node);

            // call nodeChanged for the parents
        AbstractNode changeNode = node;
        while (changeNode != m_treeRootNode)
        {
            super.nodeChanged(changeNode);
            changeNode = (AbstractNode)changeNode.getParent();
        }
        // call nodeChanged for the children
        Enumeration en = node.depthFirstEnumeration();
        while (en.hasMoreElements())
        {
            AbstractNode descendant = (AbstractNode)en.nextElement();
            super.nodeChanged(descendant);
        }
            super.nodeChanged(node);
        }

    private void removeAlertWhenMetricsDisabled(AbstractNode node){
        try {
            if (node instanceof Node) {
                AlertsModel alertsModel = ((IAlertsProvider) node).getAlertsModel();
                if(alertsModel!=null)
                {
                    alertsModel.setAlerts(null);
                }
            } else if (node instanceof ParentNode) {
                Enumeration en = ((ParentNode) node).children();
                while (en.hasMoreElements()) {
                    removeAlertWhenMetricsDisabled((AbstractNode)en.nextElement());
                }
            }

        } catch (Exception e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
    }
    /**
     * Traverses node branch to create set of IMetricIdentity for leafs(Node)
     * and InstanceParentNode( with <>.* pattern).
     *
     * Used in enableMetric, disableMetric calls
     *
     * @param node                 The node under which to find the identities.
     * @param identities           The set in-which to store the identities.
     * @param enable               true if this is for metric enabling otherwise
     *                             false (disableMetric).
     */
    private void setIdentities(AbstractNode node,
                               HashSet      identities,
                               boolean      enable,
                               int          instanceDisableMode)
    {
        if (node instanceof Node) // simple add
        {
            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            identities.add(metricId);
        }
        else if (node instanceof ParentNode) // walk the children
        {
            Enumeration en = ((ParentNode)node).children();
            while (en.hasMoreElements())
            {
                setIdentities((AbstractNode)en.nextElement(), identities, enable,instanceDisableMode);
            }
        }
        else if (node instanceof InstanceParentNode) // build new identity with * pattern
        {
            // When enabling a metric all we want to do for an instance parent
            // is add the '*' wildcard pattern...
            if (enable)
            {
                IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                IMetricIdentity patternId = MetricsFactory.createMetricIdentity(parentId, "*");
                identities.add(patternId);
            }
            else
            {
                // But when disabling an instance metric we can do one of three
                // things...
                switch (instanceDisableMode)

                {
                    case DISABLE_INSTANCE_NONE:
                        break;  // Do nothing
                    case DISABLE_INSTANCE_ALL:
                    {   // Disable (remove) all patterns currently set.
                        try
                        {
                            IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                            Object[] metricAndAlertInfo = ((IConfigMetricPlugin) source).getMetricAndAlertInfo();
                            IMetricIdentity[] activeMetrics = (IMetricIdentity[]) metricAndAlertInfo[0];
                            for (int i = 0; i < activeMetrics.length; i++) {
                                IMetricIdentity activeMetric = activeMetrics[i];
                                if(activeMetric.getName().startsWith(metricId.getName()))
                                {
                                    identities.add(activeMetric);
                                }
                            }
                        }
                        catch (Exception e)
                        {
                            // Severe problem if we fail to get the enabled metrics.
                            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                        }
                        break;
                    }
                    case DISABLE_INSTANCE_WILDCARD:
                    default:
                    {   // Disable (remove) the '*' wildcard pattern.
                        IMetricIdentity parentId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
                        IMetricIdentity patternId = MetricsFactory.createMetricIdentity(parentId, "*");
                        identities.add(patternId);
                        break;
                    }
                }
            }
        }
        else if (node instanceof InstanceNode)
        {
            InstanceParentNode parent    = (InstanceParentNode)node.getParent();
            IMetricIdentity    parentId  = ((IMetricInfo)parent.getUserObject()).getMetricIdentity();
            IMetricIdentity    patternId = MetricsFactory.createMetricIdentity(parentId, node.toString());

            identities.add(patternId);
        }
    }



    public void enableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts)
    throws Exception
    {
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject()
                                                                : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        IAlert[] alertArray = createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);

        ((IConfigMetricPlugin)source).updateAlerts(alertArray,true);

        // update the model on the assumption that the list given are new alerts
        HashSet alerts = ((IAlertsProvider)node).getAlertsModel().getAlerts();
        for (int i = 0; i < highThresholdAlerts.length; i++)
        {
            alerts.add(MetricsFactory.createAlert(metricId, true, highThresholdAlerts[i].longValue()));
        }
        for (int i = 0; i < lowThresholdAlerts.length; i++)
        {
            alerts.add(MetricsFactory.createAlert(metricId, false, lowThresholdAlerts[i].longValue()));
        }

        super.nodeChanged(node);
    }
    public void disableAlerts(AbstractNode node, Long[] highThresholdAlerts, Long[] lowThresholdAlerts)
    throws Exception
    {
        IMetricIdentity metricId = node instanceof InstanceNode ? (IMetricIdentity)node.getUserObject()
                                                                : ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        IAlert[] alertArray = createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);

        ((IConfigMetricPlugin)source).updateAlerts(alertArray,false);

        HashSet alerts = ((IAlertsProvider)node).getAlertsModel().getAlerts();
        for (int i = 0; i < highThresholdAlerts.length; i++)
        {
            removeAlert(alerts, true, highThresholdAlerts[i].longValue());
        }
        for (int i = 0; i < lowThresholdAlerts.length; i++)
        {
            removeAlert(alerts, false, lowThresholdAlerts[i].longValue());
        }

        super.nodeChanged(node);
    }

    private void disableAlertsWhenMetricsDisabled(IMetricIdentity[] metricIds, AbstractNode node) throws Exception {
        for (int i = 0; i < metricIds.length; i++) {
            AlertsModel alertsModel = getAlertsModelForANode(node.children(), metricIds[i].getName());
            if(alertsModel != null){
                ArrayList highThresholdValues = alertsModel.getHighThresholdValues();
                Long[] ht = (Long[]) highThresholdValues.toArray(new Long[0]);

                ArrayList lowThresholdValues = alertsModel.getLowThresholdValues();
                Long[] lt = (Long[]) lowThresholdValues.toArray(new Long[0]);

                disableAlerts(metricIds[i],ht,lt);
                removeAlertWhenMetricsDisabled(node);
            }
        }
    }

    public void disableAlerts(IMetricIdentity metricId, Long[] highThresholdAlerts, Long[] lowThresholdAlerts)
    throws Exception
    {
        IAlert[] alertArray = createAlertArray(metricId, highThresholdAlerts, lowThresholdAlerts);

        ((IConfigMetricPlugin)source).updateAlerts(alertArray,false);
    }

    private IAlert[] createAlertArray(IMetricIdentity metricId, Long[] highThresholdAlerts, Long[] lowThresholdAlerts)
    {
        int alertCount = (highThresholdAlerts == null ? 0 : highThresholdAlerts.length) +
                         (lowThresholdAlerts == null ? 0 : lowThresholdAlerts.length);

        IAlert[] alerts = new IAlert[alertCount];
        if (lowThresholdAlerts != null)
        {
            for (int i = lowThresholdAlerts.length - 1; i >= 0; i--)
            {
                alerts[--alertCount] = MetricsFactory.createAlert(metricId, false, lowThresholdAlerts[i].longValue());
            }
        }

        if (highThresholdAlerts != null)
        {
            for (int i = highThresholdAlerts.length - 1; i >= 0; i--)
            {
                alerts[--alertCount] = MetricsFactory.createAlert(metricId, true, highThresholdAlerts[i].longValue());
            }
        }

        return alerts;
    }
    private void removeAlert(HashSet alerts, boolean isHighThreshold, long threshold)
    {
        Iterator iterator = alerts.iterator();
        while (iterator.hasNext())
        {
            IAlert alert = (IAlert)iterator.next();
            if (alert.isHighThreshold() == isHighThreshold && alert.getThresholdValue() == threshold)
            {
                alerts.remove(alert);
                return;
            }
        }
    }


    @Override
    public List getInstances(InstanceParentNode node)
    throws Exception
    {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();

        String[] instances = {"Sample.Q1","Sample.Q2"};//(String[])m_connector.invoke(m_componentName, "getInstanceMetricNames", new Object[] { metricId }, METRIC_ID_SIGNATURE);


        ArrayList instancesList = new ArrayList(instances.length);
        for (int i = 0; i < instances.length; i++)
        {
            instancesList.add(instances[i]);
        }

        return instancesList;
    }
    public String[] getEnabledMetricsPatterns(InstanceParentNode node)
    throws Exception
    {

        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        Object[] metricAndAlertInfo = ((IConfigMetricPlugin) source).getMetricAndAlertInfo();
        IMetricIdentity[] activeMetrics = (IMetricIdentity[]) metricAndAlertInfo[0];
        ArrayList instancesList = new ArrayList();
        for (int i = 0; i < activeMetrics.length; i++) {
            IMetricIdentity activeMetric = activeMetrics[i];
            if(activeMetric.getName().startsWith(metricId.getName())){
                if(activeMetric.getName().equalsIgnoreCase(metricId.getName()))
                {
                    continue;
                }
                instancesList.add(activeMetric);
            }
        }
        String[] patterns = new String[instancesList.size()];
        for (int i = 0; i < instancesList.size(); i++)
        {
            String[] patternId = ((IMetricIdentity)instancesList.get(i)).getNameComponents();
            patterns[i] = patternId[patternId.length - 1];
        }

        return patterns;
    }

    public void enableInstancePatterns(InstanceParentNode node, List instanceNames)
    throws Exception
    {
        updateInstancePatterns("enableMetrics", node, instanceNames);
        if (instanceNames.contains("*"))
        {
            this.enableMetric(node);
        }
        else if (!instanceNames.isEmpty()){
            node.setEnabled(true);
            node.setParentEnabled();
        }
    }

    public void disableInstancePatterns(InstanceParentNode node, List instanceNames)
    throws Exception
    {
        updateInstancePatterns("disableMetrics", node, instanceNames);
    }

    private void updateInstancePatterns(String updateOperation, InstanceParentNode node, List instanceNames)
    throws Exception
    {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] nameComponents = metricId.getNameComponents();
        String[] instanceNameComponents = new String[nameComponents.length + 1];
        System.arraycopy(nameComponents, 0, instanceNameComponents, 0, nameComponents.length);
        int instanceNameComponentIndex = instanceNameComponents.length - 1;

        // create the new indentities
        HashSet enabledIds = new HashSet();
        Iterator iterator = instanceNames.iterator();
        while (iterator.hasNext())
        {
            instanceNameComponents = (String[])instanceNameComponents.clone();
            instanceNameComponents[instanceNameComponentIndex] = (String)iterator.next();
            enabledIds.add(MetricsFactory.createMetricIdentity(instanceNameComponents));
        }
        // now enable/disable them
        IMetricIdentity[] metricIds = (IMetricIdentity[])enabledIds.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
        boolean opertaionType = updateOperation.equals("disableMetrics");
        ((IConfigMetricPlugin)source).updateMetrics(opertaionType ?false:true,metricIds);
        if(opertaionType){
            disableAlertsWhenMetricsDisabled(metricIds,node);
        }
        refreshTree();
        super.nodeStructureChanged(node);
    }

    private AlertsModel getAlertsModelForANode(Enumeration enumeration, String metricName) {
        AlertsModel alertsModel = null;
        if(enumeration != null){
            while(enumeration.hasMoreElements()){
                InstanceNode instanceNode = (InstanceNode) enumeration.nextElement();
                MetricIdentity userObject = (MetricIdentity) instanceNode.getUserObject();
                if(userObject.getName().equalsIgnoreCase(metricName)){
                    alertsModel = instanceNode.getAlertsModel();
                    break;
                }
            }
        }
        return alertsModel;
    }

    @Override
    public void refreshMetricValues(IMetricIdentity[] id) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void addValueListener(IMetricIdentity metricId, IValueListener listener) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void removeValueListener(IMetricIdentity metricId, IValueListener listener) {
        //To change body of implemented methods use File | Settings | File Templates.
    }


}
