package com.sonicsw.ma.gui.config.propsheets;

import java.util.Iterator;

import modelobjects.framework.model.ModelDescriptor;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.util.AttributeDescriptionMapIterator;


public class ConfigBeanModelDescriptor extends ModelDescriptor
{
    protected IAttributeDescription m_type = null;


    public ConfigBeanModelDescriptor()
    {
        this(null);
    }

    public ConfigBeanModelDescriptor(IAttributeDescription type)
    {
        super(ConfigBeanModel.class);

        addModelAspectAdapter(ConfigBeanModel.NAME, String.class, false);

        setType(type);
    }

    public final void setType(IAttributeDescription type)
    {
        if ((type != null) && (type != m_type))
        {
          m_type = type;

          //This will add an aspect adapter for every attribute descriptor
          //(recursively) for the given IAttributeDescriptionMap
          //
          Iterator i = new AttributeDescriptionMapIterator(m_type);

          while (i.hasNext())
          {
              IConfigPath           path     = (IConfigPath)i.next();
              IAttributeDescription adObject = type.getAttributeDescription(path);

              addModelAspectAdapter(path, adObject);
          }
       }
    }

    public IAttributeDescription getType()
    {
        return m_type;
    }

    public void addModelAspectAdapter(IConfigPath           path,
                                      IAttributeDescription desc)
    {
        Class   type     = desc.getType();
        boolean readOnly = (desc.getProperty(IAttributeDescription.FIXED_PROPERTY) != null);

        addModelAspectAdapter(path, type, readOnly);
    }

    protected final void addModelAspectAdapter(IConfigPath path,
                                         Class       type,
                                         boolean     readOnly)
    {
        addModelAspectAdapter(new ConfigBeanModelAspectAdapter(path, type, readOnly));
    }

}
