package com.sonicsw.ma.gui.config.propsheets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;

import javax.swing.Icon;

public class ConfigIcon implements Icon
{
    private boolean m_isFromType;
    private boolean m_isRequired;


    public ConfigIcon()
    {
        this(false, false);
    }

    public ConfigIcon(boolean isFromType, boolean isRequired)
    {
        m_isFromType = isFromType;
        m_isRequired = isRequired;
    }

    public boolean isFromType()
    {
        return m_isFromType;
    }

    public boolean isRequired()
    {
        return m_isRequired;
    }

    public void setFromType(boolean isFromType)
    {
        m_isFromType = isFromType;
    }

    public void setRequired(boolean isRequired)
    {
        m_isRequired = isRequired;
    }

    @Override
    public int getIconHeight()
    {
      return 12;
    }

    @Override
    public int getIconWidth()
    {
        return getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        // Debug border...
        //
        //g.setColor(Color.GRAY);
        //g.drawRect(x, y, getIconWidth(), getIconHeight());


        if (isRequired())
        {
            g.setColor(Color.RED);

            FontMetrics fm     = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds("*", g);

            int xoff = getIconWidth()  - (int)Math.abs(bounds.getWidth());
            int yoff = (getIconHeight() - (int)Math.abs(bounds.getHeight())) / 2;

            g.drawString("*", x + xoff, y + yoff + (int)Math.abs(bounds.getY()));
        }

        if (isFromType())
        {
            Font oldFont = g.getFont();

            g.setColor(Color.BLUE);
            g.setFont(oldFont.deriveFont(0, oldFont.getSize()-2));

            FontMetrics fm     = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds("D", g);

            int xoff = 0;
            int yoff = (getIconHeight() - (int)Math.abs(bounds.getHeight())) / 2;

            g.drawString("D", x + xoff, y + yoff + (int)Math.abs(bounds.getY()));

            g.setFont(oldFont);
        }
    }
}
