/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.config.propsheets;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import com.sonicsw.ma.gui.propsheets.ITabbedDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.mx.config.IAttributeDescription;

public abstract class JConfigTabbedDialog extends JConfigDialog
                                          implements ITabbedDialog
{
    private JTabbedPane m_tab;

    public JConfigTabbedDialog(JMAFrame parent, String name, IAttributeDescription type)
    {
        super(parent, name, type);
    }

    public JConfigTabbedDialog(JConfigDialog parent, String name, IAttributeDescription type)
    {
        super(parent, name, type);
    }

    @Override
    protected void internalInitialize()
    {
        super.internalInitialize();

        m_tab = new JTabbedPane(JTabbedPane.TOP);
        m_tab.setBorder(new javax.swing.border.EmptyBorder(JPartitionPanel.BORDER_SIZE,JPartitionPanel.BORDER_SIZE,0,JPartitionPanel.BORDER_SIZE));

        getContentPane().add(m_tab);
    }

    //-------------------------------------------------------------------------
    //
    // ITabbedPropSheet Implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void addTabPanel(String name, JPanel panel)
    {
        m_tab.addTab(name, panel);
    }

    @Override
    public void insertTabPanel(String name, JPanel panel, int pos)
    {
        m_tab.insertTab(name, null, panel, null, pos);
    }

    @Override
    public boolean removeTabPanel(String name)
    {
        int index = m_tab.indexOfTab(name);

        if (index >= 0)
        {
            m_tab.removeTabAt(index);
        }

        return (index >= 0);
    }

    @Override
    public void setEnableTabPanel(String name, boolean enable)
    {
        int index = m_tab.indexOfTab(name);

        if (index >= 0)
        {
            m_tab.setEnabledAt(index, enable);
        }
    }

    @Override
    public JTabbedPane getTabbedPane()
    {
        return m_tab;
    }

}
