package com.sonicsw.ma.gui.config.revert;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.Action;
import javax.swing.JButton;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.treetable.JTreeTable;
import com.sonicsw.ma.gui.treetable.TreeTableModelAdapter;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;

public class JRevertDialog extends JMADialog
{
    private IConfigPlugin m_plugin;
    private JTreeTable    m_treeTable;

    private JButton m_okButton = new JButton(new OKAction());

    public JRevertDialog(JMAFrame parent, IConfigPlugin plugin)
    {
        super(parent, "edit.config.revert");

        m_plugin = plugin;
    }

    @Override
    protected void maInitialize()
    {
        IConfigBean bean = (IConfigBean)((ConfigBeanModel)m_plugin.getModel()).getData();

        m_treeTable = new JTreeTable(new RevertAttributeTreeTableModel(getPlugin()));
        m_treeTable.setRootVisible(false);
        m_treeTable.getTree().setShowsRootHandles(true);

        getContentPane().add(JPartitionPanel.merge("r", true, new Component[] { new ExtendedJScrollPane(m_treeTable) }));
    }

    @Override
    protected void maCleanup()
    {
        m_plugin    = null;
        m_treeTable = null;
    }

    public ConfigAttributeSource[] getAttributesToRevert()
    {
        int[]     sel = m_treeTable.getSelectedRows();
        ArrayList res = new ArrayList(sel.length);

        TreeTableModelAdapter adapter = (TreeTableModelAdapter)m_treeTable.getModel();
        IConfigServer         server  = getBean().getConfigServer();

        for (int i = 0; i < sel.length; i++)
        {
            ConfigAttributeTreeTableNode row  = (ConfigAttributeTreeTableNode)adapter.getValueAt(sel[i], 0);
            res.add(row.getConfigAttributeSource());
        }

        return (ConfigAttributeSource[])res.toArray(new ConfigAttributeSource[res.size()]);
    }

    private void validateAttributesToRevert()
    throws Exception
    {
        int[]     sel = m_treeTable.getSelectedRows();
        ArrayList res = new ArrayList(sel.length);

        TreeTableModelAdapter adapter = (TreeTableModelAdapter)m_treeTable.getModel();
        IConfigServer         server  = getBean().getConfigServer();

        for (int i = 0; i < sel.length; i++)
        {
            ConfigAttributeTreeTableNode instance  = (ConfigAttributeTreeTableNode)adapter.getValueAt(sel[i], 0);
            Object value = instance.getValue();
            
            if (value == null) //attribute removed from instance
            {
                ConfigAttributeTreeTableNode parent = instance.getParent();
                IConfigBean pBean = parent.getConfigBean();
                
                if(pBean != null && pBean.isPrototypeInstance())
                {
                    IConfigPrototype prototype = pBean.getPrototype();
                    value = prototype.getAttribute(parent.getConfigPath(pBean));
                    validateAttribute(value, false);
                }
            }
            else
            {
                validateAttribute(value, true);
            }
        }
    }
    
    private void validateAttribute(Object attribute, boolean isInstance)
    throws Exception
    {
        if (attribute instanceof IConfigBean)
        {
            //check if it is hard reference
            String pluginPath =(isInstance ? m_plugin.getPluginPath() : getPrototypePath());
                
            if (((IConfigBean)attribute).getName().startsWith(pluginPath))
            {
                throw new Exception("Cannot revert the selected path(s). Within one of the selected path(s) there is a reference to another configuration.");
            }
            
        }
        
        if (attribute instanceof IAttributeMap)
        {
            //recurcively check if it contains child that is IConfigReference
            Iterator i = ((com.sonicsw.mx.config.impl.AttributeMapImpl)attribute).getAllAttributeNames().iterator();

            while (i.hasNext())
            {
                IAttributeMap      valueMap = (IAttributeMap)attribute;
                String             key      = (String)i.next();
                Object             val      = valueMap.getAttribute(key);
                validateAttribute(val, isInstance);
            }     
        }
        
        if (attribute instanceof IAttributeList)
        {
            //recurcively check if it contains child that is IConfigReference
            for (int i = 0; i < ((IAttributeList)attribute).size(); i++)
            {
                IAttributeList     valueList = (IAttributeList)attribute;
                String             key       = Integer.toString(i);
                Object             val       = valueList.getAttribute(i);
                validateAttribute(val, isInstance);
            }
        }
    }
    
    private String getPrototypePath()
    {
        String path = null;
        
        IConfigBean bean = getBean();
        path = bean.getPrototype().getName();
        
        int index = path.lastIndexOf("_Default");
        if (index >= 0)
        {
            path = path.substring(0, index);
        }

        return path;
    }
    
    protected IConfigPlugin getPlugin()
    {
        return m_plugin;
    }

    protected IConfigBean getBean()
    {
        ConfigBeanModel model = (ConfigBeanModel)getPlugin().getModel();
        IConfigBean     bean  = (IConfigBean)model.getData();

        return bean;
    }

   @Override
public Action[] getButtonActions()
   {
       return new Action[] { m_okButton.getAction(), getDefaultCancelAction() };
   }

   private class OKAction extends BasicGuiAction
   {
       public OKAction() { super("dialog.ok", getDefaultOKAction()); }

       @Override
    public void actionPerformed(ActionEvent evt)
       {
           try
           {
               JRevertDialog.this.validateAttributesToRevert();
           }
           catch(Exception e)
           {
               MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, e.getMessage(), e, true);
               return;
           }
           
           super.actionPerformed(evt);
       }

   }

}
