package com.sonicsw.ma.gui.config.revert;

import java.awt.event.ActionEvent;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;

public class RevertAction extends BasicPluginAction
{
    public RevertAction(IPlugin plugin)
    {
        super(plugin, "edit.revert");
    }

    @Override
    public boolean isEnabled()
    {
        boolean res = false;

        if (getPlugin() instanceof IConfigPlugin)
        {
            String pVersion = ((IConfigPlugin)getPlugin()).getAttributes().getProductVersion();

            if ((pVersion != null) && (pVersion.startsWith("5.") || pVersion.equals("2.0")))
            {
                ; // We want the default return value, i.e. disabled
            }
            else
            if (((IConfigPlugin)getPlugin()).isTemplateInstance())
            {
                res = true;
            }
        }

        return res;
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (getBean().getPrototype() == null)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_WARNING,
                "Meta-attributes mismatch - configuration is not a template instance", true);
            return;
        }

        IConfigServer server = getBean().getConfigServer();

        if (!(server instanceof com.sonicsw.mx.config.impl.ConfigServer))
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "Can't perform revert operation - invalid ConfigServer", true);
        }

        JRevertDialog dlg = new JRevertDialog(MgmtConsole.getMgmtConsole(), (IConfigPlugin)getPlugin());

        dlg.setVisible(true);

        if (dlg.getCloseCommand() == JMADialog.CLOSE_OK)
        {
            ConfigAttributeSource[] src = dlg.getAttributesToRevert();

            for (int i = 0; i < src.length; i++)
            {
                try
                {
                    String        name  = src[i].getBean().getName();
                    IConfigPath[] paths = src[i].getPaths();

                    logRevert(name, paths);

                    ((com.sonicsw.mx.config.impl.ConfigServer)server).revertToTemplate(name, paths);
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                                              "Failed to revert attribute(s)", e, false);
                }
            }
        }
    }

    private void logRevert(String name, IConfigPath[] paths)
    {
        StringBuffer sb = new StringBuffer("revert ");

        sb.append(name).append(" = ");

        for (int j = 0; j < paths.length; j++)
        {
            if (j > 0)
            {
                sb.append(", ");
            }

            sb.append(paths[j]);
        }

        Helper.logDebugMessage(sb.toString());
    }

    protected IConfigBean getBean()
    {
        ConfigBeanModel model = (ConfigBeanModel)getPlugin().getModel();
        IConfigBean     bean  = (IConfigBean)model.getData();

        return bean;
    }
}
