package com.sonicsw.ma.gui.config.revert;

import com.sonicsw.ma.gui.treetable.AbstractTreeTableModel;
import com.sonicsw.ma.gui.treetable.TreeTableModel;
import com.sonicsw.ma.gui.util.ReferenceToStringConverter;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;

public class RevertAttributeTreeTableModel extends AbstractTreeTableModel implements TreeTableModel
{
    static protected String[] cNames = { "Attribute", "Current Value", "Template Value", };
    static protected Class[]  cTypes = { TreeTableModel.class, Object.class, Object.class };

    public RevertAttributeTreeTableModel(IConfigPlugin plugin)
    {
        super(new ConfigAttributeTreeTableNode(plugin));
    }

    protected Object getInstanceValue(Object node)
    {
        ConfigAttributeTreeTableNode cnode = (ConfigAttributeTreeTableNode)node;
        Object value = cnode.getValue();

        if ((value instanceof IAttributeMap) || (value instanceof IAttributeList))
        {
            return null;
        }

        return value;
    }

    protected Object getTemplateValue(Object node)
    {
        Object                       value    = null;
        ConfigAttributeTreeTableNode n        = (ConfigAttributeTreeTableNode)node;
        IConfigBean                  instance = n.getConfigBean();

        if (instance.isPrototypeInstance())
        {
            Object iValue = getInstanceValue(node);

            IConfigPrototype prototype = instance.getPrototype();

            value = prototype.getAttribute(n.getConfigPath(instance));

            if ((value instanceof IAttributeMap) ||
                (value instanceof IAttributeList))
            {
                if ((value instanceof IConfigBean) && (iValue == null))
                {
                   String pName = ((IConfigBean)value).getName();

                   if (pName.endsWith(ConfigServerUtility.DEFAULT_SUFFIX) ||
                       pName.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX) ||
                       pName.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX))
                   {
                       pName = pName.substring(0, pName.lastIndexOf('/'));
                   }

                    value = ReferenceToStringConverter.convertToView(pName);
                }
                else
                {
                    value = null;
                }
            }
        }

        return value;
    }

    protected Object[] getChildren(Object node) { return ((ConfigAttributeTreeTableNode)node).getChildren(); }
    @Override
    public int getChildCount(Object node) { return (getChildren(node) == null) ? 0 : getChildren(node).length; }
    @Override
    public Object getChild(Object node, int i) { return getChildren(node)[i]; }
    @Override
    public boolean isLeaf(Object node) { return ((ConfigAttributeTreeTableNode)node).isLeaf(); }

    //
    //  The TreeTableNode interface.
    //
    @Override
    public int getColumnCount() { return cNames.length; }
    @Override
    public String getColumnName(int column) { return cNames[column]; }
    @Override
    public Class getColumnClass(int column) { return cTypes[column]; }
    @Override
    public Object getValueAt(Object node, int column)
    {
        switch(column)
        {
            case 0 : return node;
            case 1 : return getInstanceValue(node);
            case 2 : return getTemplateValue(node);
        }

        return null;
    }
}
