/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.dev;

import java.util.List;
import java.util.Map;

import javax.swing.JComponent;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.ConfigBeanFile;

public class DevElementPlugin extends AbstractDevPlugin
{
    public static final String PLUGIN_TYPE     = ConfigBeanFile.CONFIG_TYPE;
    public static final String CONFIG_VERSION  = ConfigBeanFile.CONFIG_VERSION;

    public static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.TYPE,           PLUGIN_TYPE },
        { PluginAttributes.DISPLAY_TYPE,   "File" },
        { PluginAttributes.CONFIG_VERSION, CONFIG_VERSION },
    };

    private DevModel m_model = null;
    
    
    public DevElementPlugin(IPluginContext context, String id, Map data)
    {
        super(context, id, data);

        getAttributes().put(ATTRIBUTES);
        getAttributes().put(data);

        setDisplayable(false);
    }

    @Override
    public void dispose()
    {
        m_model = null;
        
        super.dispose();
    }

    @Override
    public boolean expand()
    {
        return false;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        return new JDevPropertiesDialog(MgmtConsole.getMgmtConsole());
    }

    @Override
    public List getToolTipList()
    {
        List list  = super.getToolTipList();

        DevModel model = (DevModel)getModel();

        list.add(formatToolTipText("Size",          formatSize(model.getSize())));
        list.add(formatToolTipText("Date Modified", model.getLastModifiedTime()));

        return list;
    }

    @Override
    protected JComponent[] getPluginMenuItems()
    {
        return super.getPluginMenuItems();
    }

    @Override
    protected JComponent[] getSystemMenuItems()
    {
        return super.getSystemMenuItems();
    }
    
    @Override
    public Object getModel()
    {
        if (m_model == null)
        {
            m_model = new DevModel(this);
        }
    
        return m_model;
    }

    /**
     * Indicates whether or not the file element plugin has any content.
     *
     * @return  false if no content (blob) has been stored or true if the
     *          element has blob info.
     */
    @Override
    public boolean hasContent()
    {
        boolean res = false;

        try
        {
            IConfigBeanFile bean = getFileByPath(getPluginPath());

            if ((bean != null) && (bean.getContents() != null))
            {
                res = true;
            }
        }
        catch (ConfigServiceException e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }

        return res;
    }

    /**
     * This method is called when the plugin (and any data representing it)
     * is to be deleted. The implementation is responsible for removing any
     * child plugin's and associated data.
     *
     * The plugin(s) are removed from the tree/content pane asynchronously
     * by notification from the Directory Service.
     *
     * @param server      (transaction) config server to use for the delete
     * @throws Exception  if for some reason the operation cannot be performed
     *                    or completed then an exception will be thrown
     */
    @Override
    public void deletePlugin(IConfigServer configServer)
        throws Exception
    {
        configServer.removeConfigElement(getPluginPath());
    }
}
