/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.dev;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.ObjectColumn;
import com.sonicsw.ma.gui.table.PluginAttributesTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginContentPane;
import com.sonicsw.ma.gui.table.PluginCreatedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginModifiedTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginSizeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginTypeTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginVersionTableCellRenderer;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IPluginFilter;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.IElementIdentity;

public class DevFolderPlugin extends AbstractDevPlugin implements IFolderPlugin
{
    public static final String DISPLAY_TYPE = "Folder";

    private static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.DISPLAY_TYPE,     DISPLAY_TYPE },
        { PluginAttributes.IS_CHILD_BEARING, Boolean.TRUE },
    };

    protected DevModel m_model = null;

    public DevFolderPlugin(IPluginContext context, String id, Map data)
    {
        super(context, id, data);

        getAttributes().put(ATTRIBUTES);
        
        String type = (data != null) ? (String)data.get(PluginAttributes.TYPE) : null;

        if (type != null)
        {
            getAttributes().set(PluginAttributes.TYPE, type);
        }
    }

    @Override
    public IContentPane createPluginContentPane()
    {
       return new FileFolderContentPane();
    }

    @Override
    public BasicAction getDefaultAction()
    {
        return new FolderPluginExpandAction(this);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        return new JDevPropertiesDialog(MgmtConsole.getMgmtConsole());
    }

    @Override
    public boolean expand()
    {
        JProgressBar bar = MgmtConsole.getMgmtConsole().getStatusBar().getProgressBar();

        try
        {
            Set childSet = getPluginContext().getConfigContext().getConfigServer().list(getPluginPath());
            Iterator i = (childSet != null) ? childSet.iterator() : null;
            int nPluginCount = (childSet != null) ? childSet.size() : 0;
            int nCount = 0;

            if (bar != null)
            {
                bar.setMinimum(0);
                bar.setMaximum(nPluginCount);
                bar.setVisible(true);
            }

            while ((i != null) && i.hasNext())
            {
                HashMap row = (HashMap)i.next();
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_PROGRESS,
                    "Loading file element " + ++nCount + " of " + nPluginCount, null, false);
                if (bar != null)
                {
                    bar.setValue(nCount);
                }
                addChildPlugin(createChildPlugin(null, row), row);
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "FileFolderPlugin::expand failed", e, true);
        }
        finally
        {
            if (bar != null)
            {
                bar.setVisible(false);
                MgmtConsole.getMgmtConsole().getStatusBar().releaseProgressBar();
            }
        }
        return true;
    }

    @Override
    protected IPlugin createChildPlugin(String strName, Map metaAttributes)
    {
        AbstractGUIPlugin plugin = null;

        try
        {
            if (metaAttributes.containsKey(IConfigServer.FOLDER_NAME))
            {
                String metaName = (String)metaAttributes.get(IConfigServer.FOLDER_NAME);
                metaName = metaName.substring(metaName.lastIndexOf('/') + 1);

                metaAttributes.remove(IConfigServer.FOLDER_NAME);

                plugin = new DevFolderPlugin(getPluginContext(), metaName, metaAttributes);
            }
            else
            {
                IElementIdentity eid = (IElementIdentity)metaAttributes.get(IConfigServer.ELEMENT_IDENTITY);

                if (eid != null)
                {
                    String[] comp     = eid.getNameComponents();
                    String   metaName = comp[comp.length - 1];

                    metaAttributes.remove(IConfigServer.ELEMENT_IDENTITY);

                    plugin = new DevElementPlugin(getPluginContext(), metaName, metaAttributes);
                }
                else
                {
                    Helper.logDebugMessage("createChildPlugin: ELEMENT_IDENTITY is non-existant.");
                }
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "FileFolderPlugin::createChildPlugin failed", e, false);
        }
        return plugin;
    }

    @Override
    public Object getModel()
    {
        if (m_model == null)
        {
            m_model = new DevModel(this);
        }

        return m_model;
    }

    /**
     * This method is called when the plugin (and any data representing it)
     * is to be deleted. The implementation is responsible for removing any
     * child plugin's and associated data.
     *
     * The plugin(s) are removed from the tree/content pane asynchronously
     * by notification from the Directory Service.
     *
     * @param server      (transaction) config server to use for the delete
     * @throws Exception  if for some reason the operation cannot be performed
     *                    or completed then an exception will be thrown
     */
    @Override
    public void deletePlugin(IConfigServer configServer)
    throws Exception
    {
        // AHJ - This was done for a ConfigFolder....
        // We are just going to do a recursive delete on all the configurations
        // under the Broker FolderElement in the DS
        //getPluginContext().getConnectionInfo().getConfigServerUtility().deleteBeanPath(configServer, getPluginPath());

    	List list = buildDeleteList(configServer, getPluginPath(), new ArrayList());

    	Iterator i = list.iterator();
    	while (i.hasNext())
    	{
    		String entry = (String)i.next();
    		
    		if (entry.endsWith("/"))
            {
                configServer.deleteFolder(entry);
            }
            else
            {
                configServer.removeConfigElement(entry);
            }
    	}
    }

    private List buildDeleteList(IConfigServer configServer, String path, List list)
    throws Exception
	{
    	Iterator i = configServer.list(path).iterator();

    	String tmp = path;
    	if (!tmp.endsWith("/"))
        {
            tmp += "/";
        }
    	list.add(0, tmp);
    	
    	while (i.hasNext())
    	{
    		Map file = (Map)i.next();
    		String type = (String)file.get(ConfigServerUtility.TYPE);
    		String filePath = null;
    		IElementIdentity ei = (IElementIdentity)file.get(IConfigServer.ELEMENT_IDENTITY);
    		if (ei != null)
            {
                filePath = ei.getName();
            }
            else
            {
                filePath = (String)file.get(IConfigServer.FOLDER_NAME);
            }
    		
    		if ((type != null) && !type.equals(com.sonicsw.mx.config.impl.ConfigBeanFile.CONFIG_TYPE))
            {
                throw new Exception ("Folder contain configuration '" + filePath + "'");
            }
    		
    		if (ei == null)
    		{
    			if (filePath == null)
                {
                    throw new Exception("Unknown entity found in File System under '" + path + "'");
                }

    			buildDeleteList(configServer, filePath, list);
    		}
    		else
    		{
    			list.add(0, ei.getName());
    		}
    	}
    	
    	return list;
    }
    
    //-------------------------------------------------------------------------
    //
    // Inner Classes
    //
    //-------------------------------------------------------------------------

    class FileFolderContentPane extends PluginContentPane
    {
        public FileFolderContentPane()
        {
            super(DevFolderPlugin.this);
        }

        @Override
        public TableColumn[] getColumns()
        {
            return new TableColumn[]
            {
                new ObjectColumn(0, "Name",          30, new PluginNameTableCellRenderer()),
                new ObjectColumn(1, "Size",          20, new PluginSizeTableCellRenderer()),
                new ObjectColumn(2, "Type",          30, new PluginTypeTableCellRenderer()),
                new ObjectColumn(3, "Date Modified", 25, new PluginModifiedTableCellRenderer()),
                new ObjectColumn(4, "Date Created",  25, new PluginCreatedTableCellRenderer()).setDefaultVisible(false),
                new ObjectColumn(5, "Attributes",    10, new PluginAttributesTableCellRenderer()).setDefaultVisible(false),
                new ObjectColumn(6, "Version",       15, new PluginVersionTableCellRenderer()).setDefaultVisible(false),
            };
        }

        @Override
        protected List getRowModel(IPlugin plugin)
        {
            IPluginFilter     filter = plugin.getFilter();
            AbstractGUIPlugin parent = (AbstractGUIPlugin)plugin;
            ArrayList         list   = new ArrayList();

            for (int i = 0; i < parent.getChildCount(); i++)
            {
                IPlugin child = (IPlugin)parent.getChildAt(i);

                if (child != null && ((filter != null) && filter.isPluginVisible(JTable.class, child)))
                {
                    list.add(child);
                }
            }
            return list;
        }
    }
}
