/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.dev;

import javax.swing.Icon;
import javax.swing.UIManager;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.file.FileAssociationManager;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;

import com.sonicsw.mf.common.IDirectoryAdminService;

public class DevModel
{
    private AbstractDevPlugin m_plugin = null;
    private IConfigBean m_bean;

    public DevModel(AbstractDevPlugin plugin)
    {
        m_plugin = plugin;
    }

    private IConfigBean getModel()
    {
        if (m_plugin instanceof IFolderPlugin)
        {
            return null;
        }

        if (m_bean == null)
        {
            if (m_plugin.getAttributes().getType().equals(DevElementPlugin.PLUGIN_TYPE))
            {
                m_bean = m_plugin.getFileByPath(m_plugin.getPluginPath());
            }
            else
            {
                m_bean = (IConfigBean)getConfigElement(m_plugin.getPluginPath());
            }
        }
        
        return m_bean;
    }
    
    public String getName()
    {
        return m_plugin.getPluginName();
    }

    public String getPath()
    {
        return m_plugin.getPluginPath();
    }

    public Long getSize()
    {
        IConfigBean model = getModel();
        
        if (model instanceof IConfigBeanFile)
        {
            return new Long(((IConfigBeanFile)model).getFileSize());
        }
        
        return null;
    }

    public String getLastModifiedTime()
    {
        IConfigBean model = getModel();

        if (model instanceof IConfigBeanFile)
        {
            return Helper.getDateTimeString(new Long(((IConfigBeanFile)model).getLastModifiedTime()));
        }

        return null;
    }

    public String getCreationTime()
    {
        IConfigBean model = getModel();
        
        if (model instanceof IConfigElement)
        {
            long timestamp = ((IConfigElement)model).getCreationTime();
        
            if (timestamp != -1)
            {
                return Helper.getDateTimeString(new Long(timestamp));
            }
        }
        
        return null;
    }

    public String getCreatedBy()
    {
        IConfigBean model = getModel();
        
        if (model instanceof IConfigBeanFile)
        {
            return ((IConfigBeanFile)model).getCreateBy();
        }
            
        return null;
    }

    public String getType()
    {
        if (m_plugin instanceof IFolderPlugin)
        {
            return m_plugin.getAttributes().getDisplayType();
        }
        
        if (m_plugin.getAttributes().getType().equals(DevElementPlugin.PLUGIN_TYPE))
        {
            return FileAssociationManager.getAssociation(m_plugin.getPluginName()).getDescription();
        }
        
        return "Configuration";
    }

    public Icon getTypeIcon()
    {
        Icon icon = null;
        
        if (m_plugin instanceof IFolderPlugin)
        {
            icon = new ExtendedImageIcon(UIManager.getIcon("Tree.closedIcon"));

            if (m_plugin.getAttributes().getType() != null)
            {
                ((ExtendedImageIcon)icon).addOverlay(ResourceManager.getIcon(getClass(), "configoverlay"));
            }
        }
        else
        {    
            if (m_plugin.getAttributes().getType().equals(DevElementPlugin.PLUGIN_TYPE))
            {
                return (getModel() != null) ? FileAssociationManager.getAssociation(getModel().getName()).getIcon() : null;
            }
            
            return ResourceManager.getTypeIcon(getClass(), "FileConfig");
        }
        
        return icon;
    }

    public static String getFileExtension(String strFilename)
    {
        String fileExt = new String("");

        int index = strFilename.lastIndexOf('.');

        if(index != -1)
        {
            fileExt = strFilename.substring(index + 1).toUpperCase();
        }

        return fileExt.trim();
    }
    
    public boolean isSystem()
    {
        return (m_plugin != null) ? m_plugin.getAttributes().isSystem() : false;
    }
    
    public String getDsXml(IConfigElement element)
    {
        String xml = null;
        
        try
        {
            IPluginContext context = m_plugin.getPluginContext();
            String storagePath = context.getConnectionInfo().getDirectoryService().logicalToStorage(element.getName());
            IDirectoryAdminService ds = (IDirectoryAdminService)context.getConnectionInfo().getDirectoryService();
            xml = ds.exportElementToXML(storagePath);
        }
        catch(Exception e)
        {
            xml = "Failed to exportBean - " + e.getMessage();
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        
        return xml;
    }
    
    public IConfigElement getConfigElement(String logicalPath)
    {
        IConfigElement res = null;
        
        try
        {
            res = m_plugin.getPluginContext().getConfigContext().getConfigServer().loadConfigElement(logicalPath);
        }
        catch (Exception e)
        {
        }

        return res;
    }
}
