/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.dev;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.PluginSizeTableCellRenderer;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;

public class JDevPropertiesDialog extends JPropSheetTabbedDialog
{
    private JTextField m_path             = new JTextField();
    private JTextField m_type             = new JTextField();
    private JTextField m_creationTime     = new JTextField();
    private JTextField m_lastModifiedTime = new JTextField();
    private JTextField m_size             = new JTextField();
    private JTextField m_createdBy        = new JTextField();
    private JCheckBox  m_system           = new JCheckBox();

    public JDevPropertiesDialog(JMAFrame parent)
    {
        super(parent, "file-element", DevModel.class);
    }

    /**
     * Overridden method to initialize the dialog GUI.
     */
    @Override
    public void initUI() throws Exception
    {
        DevModel model = (DevModel)getModel();
        
        setTitle(model.getName() + " " + ResourceManager.getString(getClass(), "dialog.file-element.title"));

        String generalTab = ResourceManager.getString(getClass(), "dialog.file-element.tab.general.label");

        addTabPanel(generalTab, JPartitionPanel.wrap(createGeneralPanel()));

        if (getPlugin() instanceof IFolderPlugin)
        {
            
        }
        else
        if (!getPlugin().getAttributes().getType().equals(DevElementPlugin.PLUGIN_TYPE))
        {
            IConfigElement ce = model.getConfigElement(getPlugin().getPluginPath());
            
            JTextArea taInstance = new JTextArea(model.getDsXml(ce));
            taInstance.setEditable(false);
            getTabbedPane().addTab("XML",  new JScrollPane(taInstance));
            
            if (ce.isPrototypeInstance())
            {
                JTextArea taTemplate = new JTextArea(model.getDsXml(ce.getPrototype()));
                taTemplate.setEditable(false);
                getTabbedPane().addTab("Template XML", new JScrollPane(taTemplate));
            }
            
            getTabbedPane().addTab("Advanced", new JScrollPane(buildBeanInfo(ce)));
        }
    }

    /**
     * Overridden method to initialize the data for the dialog GUI.
     */
    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("path"),             m_path,             EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"),             m_type,             EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("creationTime"),     m_creationTime,     EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("lastModifiedTime"), m_lastModifiedTime, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("size"),             m_size,             EditRule.NEVER, new SizeViewValueConverter(), getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("createdBy"),        m_createdBy,        EditRule.NEVER, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"),            m_system,           EditRule.NEVER, null, getMediator());
    }

    private JPanel createGeneralPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");

        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.path.label"),             m_path);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.type.label"),             m_type);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.creationTime.label"),     m_creationTime);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.lastModifiedTime.label"), m_lastModifiedTime);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.size.label"),             m_size);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.createdBy.label"),        m_createdBy);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.system.label"),        m_system);

        return panel;
    }

    private JTextArea buildBeanInfo(IConfigElement element)
    {
        JTextArea genPane = new JTextArea();
        genPane.setEditable(false);
        
        genPane.append("Name: " + element.getName() + "\n");

        if (element instanceof IConfigBean)
        {
            genPane.append("Type: " + ((IConfigBean) element).getConfigType().getName() + "\n");
            genPane.append("Version: " + ((IConfigBean) element).getConfigType().getVersion() + "\n");
        }
        genPane.append("\n");
        genPane.append("\n" + "MODIFIED: " + element.isModified() + "\n");

        if (element instanceof IConfigPrototype)
        {
            genPane.append("TEMPLATE:" + "\n");

            try
            {
                IConfigPrototype prototype = (IConfigPrototype)element;
                Set              instances = prototype.getPrototypeInstances();
                Iterator         i         = instances.iterator();

                while (i.hasNext())
                {
                    IConfigElement instance = (IConfigElement)i.next();

                    if (instance != null)
                    {
                        genPane.append(" > " + instance.getName() + "\n");
                    }
                }
            }
            catch (ConfigServiceException e)
            {
                genPane.append(" > FAILED TO RETRIEVE INSTANCE INFO" + "\n");
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
            }
        }
        else
        if (element.getPrototype() != null)
        {
            IConfigPrototype prototype = element.getPrototype();

            genPane.append("INSTANCE OF TEMPLATE: '" + prototype.getName() + "'" + "\n");
        }

        genPane.append("\n" + "META ATTRIBUTES:" + "\n");

        try
        {
            Map      maMap = element.getMetaAttributes();
            Iterator i     = maMap.keySet().iterator();

            while (i.hasNext())
            {
                String maKey   = (String)i.next();
                Object maValue = maMap.get(maKey);

                genPane.append(maKey + " = " + maValue + "\n");
            }
        }
        catch (ConfigServiceException e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        
        return genPane;
    }
    
    class SizeViewValueConverter implements ViewValueConverter
    {
        @Override
        public Object viewValueToModel(Object viewValue)
            throws ViewValueConversionException
        {
            Object modelValue = null;

            try
            {
                if (viewValue != null)
                {
                    viewValue = Long.valueOf(viewValue.toString());
                }
            }
            catch (Exception e)
            {
                throw new ViewValueConversionException("Value is not a long!", e, ModelAspectId.forName("size"));
            }

            return modelValue;
        }

        @Override
        public Object modelValueToView(Object modelValue)
            throws ViewValueConversionException
        {
            return (modelValue != null) ? PluginSizeTableCellRenderer.formatSize((Long)modelValue) : null;
        }

        @Override
        public String[] getViewStringValues() { return null; }
        @Override
        public boolean isViewValueToModelSupported() { return true; }

        @Override
        public Class getModelClass() { return Long.class; }
        @Override
        public Class getViewClass()  { return String.class; }
    }
}
