/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.dev;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.util.FilterTreeModel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.AbstractPluginTreeCellRenderer;
import com.sonicsw.ma.plugin.DefaultPluginFilter;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;

public class JDevWorkspacePanel extends JWorkspacePanel
{
    public static final String PANEL_NAME = "Developer";

    public JDevWorkspacePanel()
    {
        setName();
    }
    
    private void setName() {
        setName(PANEL_NAME);
    }
    
    @Override
    public Icon getIcon() { return ResourceManager.getIcon(getClass(), "file"); }

    @Override
    public void initialize(IPluginContext context)
    {
        AbstractDevPlugin rootNode = new FileDomainFolderPlugin(context);
        rootNode.setFilter(new DefaultPluginFilter()); // Doesn't work without a filter!!! Why????

        m_tree.setCellRenderer(new DeveloperTreeCellRenderer());

        // Setting the initial model..a "nasty" side affect of doing this is
        // that it marks the root node as expanded without going through the
        // TreeExpansionListener mechanism.
        m_tree.setModel(new FilterTreeModel(rootNode, false, true));

        super.initialize(context);
    }

    @Override
    public void dispose()
    {
        super.dispose();
    }

    @Override
    public JComponent[] getMenuItems(int type)
    {
        return new JComponent[0];
    }

    @Override
    public AbstractButton[] getToolbarItems()
    {
        return new AbstractButton[0];
    }

    @Override
    public Object getSelectedItem()
    {
        return null;
    }

    @Override
    public Object[] getSelectedItems()
    {
        return new Object[0];
    }
    
    //------------------------------------------------------------------------
    //
    // Private classes
    //
    //------------------------------------------------------------------------
    
    private class DeveloperTreeCellRenderer extends AbstractPluginTreeCellRenderer
    {
        @Override
        public void updateRenderer(JLabel label, AbstractGUIPlugin node)
        {
            IPlugin plugin = (IPlugin)node;
            DevModel model = (DevModel)plugin.getModel();
            
            label.setIcon(model.getTypeIcon());
            label.setText(plugin.getPluginName());
        }
    }
    
    private static class FileDomainFolderPlugin extends DevFolderPlugin
    {
        public static final String PLUGIN_NAME = "File Objects";

        private static final Object[][] ATTRIBUTES =
        {
            { PluginAttributes.IS_SYSTEM, "true" },
        };

        public FileDomainFolderPlugin(IPluginContext context)
        {
            super(context, null, null);

            getAttributes().put(ATTRIBUTES);
        }

        @Override
        public String getPluginName()  { return PLUGIN_NAME; }
        @Override
        public String getPluginPath()  { return "/"; }
    }
}
