package com.sonicsw.ma.gui.domain;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JButtonPanel;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;

import com.sonicsw.mf.comm.IRetryCallback;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;

/**
 * IL: Revisit, dialog UI isn't in final version
 *
 */

public class JFailoverDialog extends JDialog
{
    short m_option = IRetryCallback.CANCEL_REQUEST;
    short[] m_allowedValues;


    public JFailoverDialog( JMAFrame parent,
                            String failedTarget,
                            String failedConnectionURL,
                            Exception e,
                            short[] allowedResponseValues )
    {

        super(parent, "", true);
        m_allowedValues = allowedResponseValues;

        prepareJFailOverDialog(failedTarget, failedConnectionURL, e);
    }
    
    private void prepareJFailOverDialog(String failedTarget, String failedConnectionURL, Exception e) {

        String title = (e instanceof InvokeTimeoutCommsException) ? "Communication Failure" : "Request Failure";

        setTitle(title);

        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        setResizable(false);

        addWindowListener(new WindowAdapter()
        {
            @Override
            public void windowClosing(WindowEvent ect)
            {
                doCancel();
            }
        });

        JButtonPanel btnPanel = new JButtonPanel(false);
        btnPanel.addButton(new FailoverAction());
        btnPanel.addButton(new RetryAction());
        btnPanel.addButton(new CancelAction());

        String text = null;
        if (e instanceof InvokeTimeoutException)
        {
            text = "Timeout while communicating with target";
        }
        else
            if (e instanceof InvokeTimeoutCommsException)
            {
                text = "Connection failure while communicating with target";
            }
            else
            {
                text = e.getMessage();
            }

        //report error to MessageViewer
        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_STATUS, text, e, false);

        JPartitionPanel failurePanel = new JPartitionPanel(false, "p,r", null);
        failurePanel.addRow("Target", new JLabel(failedTarget));
        failurePanel.addRow("URL", new JLabel(failedConnectionURL));
        failurePanel.addRow("Error message",  new JLabel(text));

        ImageIcon image = new ExtendedImageIcon( ResourceManager.getIcon(getClass(), "Domain"),
                                                 ResourceManager.getIcon(getClass(), "deleteoverlay"));


        JLabel icon = new JLabel("",image, JLabel.CENTER);
        icon.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));

        JPanel topPanel = new JPartitionPanel(false, "p,r", "");
        topPanel.add(icon);
        topPanel.add(failurePanel);

        JPanel panel = new JPartitionPanel(true, "p,p", null);
        panel.add(topPanel);

        getContentPane().add(panel);
        getContentPane().add(JPartitionPanel.merge("r,p,r", false, new Component[] { new JPanel(), btnPanel, new JPanel() }), BorderLayout.SOUTH);

        pack();

        setLocation(getCenteredLocation());
    }

    @Override
    public void setVisible(boolean state)
    {
        super.setVisible(state);
    }

    public short getResponseValue()
    {
        return m_option;
    }

    private void doCancel()
    {
        setVisible(false);
        dispose();
    }


    private Point getCenteredLocation()
    {
        Point     pLoc  = getParent().getLocation();
        Dimension pSize = getParent().getSize();
        Dimension cSize = getPreferredSize();

        return new Point (pLoc.x + ((pSize.width - cSize.width) / 2),
                          pLoc.y + ((pSize.height - cSize.height) / 2));
    }

    protected boolean isAllowedValue(short value)
    {
        for(int i = 0 ; i < m_allowedValues.length; i++)
        {
            if (m_allowedValues[i] == value)
            {
                return true;
            }
        }

        return false;
    }

    private class CancelAction extends BasicGuiAction
    {
        public CancelAction()
        {
            super("dialog.cancel");
        }

        @Override
        public boolean isEnabled()
        {
            return isAllowedValue(IRetryCallback.CANCEL_REQUEST);
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            m_option = IRetryCallback.CANCEL_REQUEST;
            JFailoverDialog.this.doCancel();
        }
    }

    private class RetryAction extends BasicGuiAction
    {
        public RetryAction()
        {
            super("dialog.retry");
        }

        @Override
        public boolean isEnabled()
        {
            return isAllowedValue(IRetryCallback.RETRY_REQUEST);
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            m_option = IRetryCallback.RETRY_REQUEST;
            JFailoverDialog.this.doCancel();
        }
    }

    private class FailoverAction extends BasicGuiAction
    {
        public FailoverAction()
        {
            super("dialog.failover");
        }

        @Override
        public boolean isEnabled()
        {
            return isAllowedValue(IRetryCallback.RETRY_REQUEST_FAILOVER);
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            m_option = IRetryCallback.RETRY_REQUEST_FAILOVER;
            JFailoverDialog.this.doCancel();
        }
    }

}//end