package com.sonicsw.ma.gui.domain;

import java.util.EventObject;

import com.sonicsw.mf.common.runtime.IState;

public class StateChangeEvent extends EventObject
{
    private short  m_operation;
    private String m_containerName;
    private String m_componentName;
    private IState m_state;

    public StateChangeEvent(AgentManagerConnection source,
                            short operation,
                            String containerName,
                            String componentName,
                            IState state)
    {
        super(source);

        m_operation     = operation;
        m_containerName = containerName;
        m_componentName = componentName;
        m_state         = state;
    }

    public short getOperation()
    {
        return m_operation;
    }

    public IState getState()
    {
        return m_state;
    }

    public String getContainerConfigName()
    {
        return m_containerName;
    }

    public String getComponentName()
    {
        return m_componentName;
    }
}