/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.file;

import java.io.File;
import java.util.Map;

import javax.swing.JComponent;

import com.sonicsw.ma.gui.JWorkspaceConfigPanel;
import com.sonicsw.ma.gui.JWorkspacePanel;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.CopyPluginAction;
import com.sonicsw.ma.gui.action.CutPluginAction;
import com.sonicsw.ma.gui.action.DeletePluginAction;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.gui.action.PropSheetAction;
import com.sonicsw.ma.gui.action.RefreshPluginAction;
import com.sonicsw.ma.gui.action.RenamePluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;

/**
 * Abstract implementation the IFilePlugin that encapsulates common
 * implementation used by all GUIFilePlugins. Most concrete GUIFilePlugin
 * implementations should extend this class and override appropriate methods.
 */
public abstract class AbstractFilePlugin extends AbstractGUIPlugin implements IFilePlugin
{
    public AbstractFilePlugin(IPluginContext context, String id, Map data)
    {
        super(context, id);
        setAttributes();
        getAttributes().put(data);
    }

    private void setAttributes() {
        setAttributes(new PluginAttributes());
    }
    
    /**
     * Release resources that the plugin is using
     */
    @Override
    public void dispose()
    {
        super.dispose();
    }

    //-------------------------------------------------------------------------

    @Override
    protected JComponent[] getPropertiesMenuItems()
    {
        return new JComponent[]
        {
            new JBasicMenuItem(new PropSheetAction(this))
        };
    }

    @Override
    protected JComponent[] getEditMenuItems()
    {
        return new JComponent[]
        {
            new JBasicMenuItem(new CutPluginAction(this)),
            new JBasicMenuItem(new CopyPluginAction(this)),
            new JBasicMenuItem(new PastePluginAction(this)),
//            new JBasicMenuItem(new PasteSpecialAction(this))
        };
    }

    @Override
    protected JComponent[] getSystemMenuItems()
    {
        return new JComponent[]
        {
            new JBasicMenuItem(new DeletePluginAction(this)),
            new JBasicMenuItem(new RenamePluginAction(this))
        };
    }

    @Override
    protected JComponent[] getViewMenuItems()
    {
        return new JComponent[]
        {
            new JBasicMenuItem(new RefreshPluginAction(this))
        };
    }

    public IConfigBeanFile getFileByPath(String strPath)
    {
        try
        {
            IConfigServer server = getPluginContext().getConfigContext().getConfigServer();

            // check to see if a configuration with this name already exists
            IConfigElement element = server.loadConfigElement(strPath);

            if(element instanceof IConfigBeanFile)
            {
                return (IConfigBeanFile)element;
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        return null;
    }

    public static String buildFilePath(String path, String file)
    {
        StringBuffer buffer = new StringBuffer(path);

        if(buffer.charAt(buffer.length()-1) != com.sonicsw.mf.common.config.IMFDirectories.MF_DIR_SEPARATOR)
        {
            buffer.append(com.sonicsw.mf.common.config.IMFDirectories.MF_DIR_SEPARATOR);
        }

        buffer.append(file);

        return buffer.toString();
    }

    public String formatSize(Long size)
    {
        long s = (size == null) ? 0 : size.longValue();

        s /= 1024;

        if (s == 0)
        {
            s = 1;
        }

        return new StringBuffer().append(s).append(" KB").toString();
    }

   /**
     * This method is called when the user has entered a new name for this
     * plugin. The plugin receiving this call will perform any additional
     * operations prior to calling into the config server to rename the
     * config element.
     *
     * @param configServer  the server with which to perform the rename
     * @param newPath       the fully qualified new name for this plugin
     * @throws Exception    if for some reason the operation cannot be performed
     *                      or completed then an exception will be thrown
     */
    @Override
    public void renamePlugin(IConfigServer configServer, String newPath)
        throws Exception
    {
        // First things first, we check to see that the names aren't the same!!
        //
        if (getPluginPath().trim().equals(newPath.trim()))
        {
            throw new Exception("Can't rename - new path is same as old path");
        }

        configServer.rename(getPluginPath(), newPath);
    }

    public boolean isDragSupported(int dropAction)
    {
        return false;
    }

    public boolean isDropSupported(int dropAction)
    {
        return false;
    }

    public void drop(IConfigPlugin dropPlugin, int dropAction)
    {
        Helper.logDebugMessage("Drop '" + dropPlugin + "' into '" + this +"' (" + dropAction + ") - not handled");
    }

    @Override
    public boolean hasContent()
    {
        return false;
    }

    @Override
    public abstract void exportFile(File file)
    throws Exception;

    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }
    
    @Override
    public int hashCode() {
        return super.hashCode();
    }
    
    @Override
    protected JWorkspacePanel getWorkspacePanel()
    {
        return getPluginContext().getWorkspace().getWorkspacePanel(JWorkspaceConfigPanel.PANEL_NAME);
    }
}