/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.file;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;

public class CreateFileAction
    extends BasicPluginAction
{
    public CreateFileAction(IPlugin plugin)
    {
        super(plugin, "file.new.file");
        putSmallIcon();
    }

    private void putSmallIcon() {
        putValue(Action.SMALL_ICON, new ExtendedImageIcon((Icon) getValue(Action.SMALL_ICON), ResourceManager.getIcon(getClass(), "newoverlay")));
    }
    
    @Override
    public void actionPerformed(ActionEvent event)
    {
        Thread t = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                CreateFileDialog dialog = new CreateFileDialog(MgmtConsole.getMgmtConsole());

                dialog.setVisible(true);

                if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
                {
                    String name = ((CreateFileDialog.Model)dialog.getModel()).getName();

                    if (name != null && !name.trim().equals(""))
                    {
                        try
                        {
                            String strPathName = AbstractFilePlugin.buildFilePath(getPlugin().getPluginPath(), name);

                            if (!((AbstractGUIPlugin)getPlugin()).pathExists(strPathName))
                            {
                                	((ConfigFolderPlugin)getPlugin()).importFile(null, strPathName);
                            }
                            else
                            {
                                MgmtConsole.getMgmtConsole().notifyMessage(IApplication.
                                    MESSAGE_ERROR,
                                    "A file with the name you specified already exists", true);
                            }
                        }
                        catch (Exception e)
                        {
                            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                "Failed to create file", e, true);
                        }
                    }
                    else
                    {
                        MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                            "No file name specified", true);
                    }
                }

            }
        });

        t.start();
    }

    @Override
    public boolean isEnabled()
    {
        return getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    //-------------------------------------------------------------------------

    class CreateFileDialog extends JPropSheetDialog
    {
        private JTextField m_name;
        private Model m_model;

        public CreateFileDialog(JMAFrame parent)
        {
            super(parent, "create.file", CreateFileDialog.Model.class);

            setResizable();

            m_model = new Model();
        }

        private void setResizable() {
            setResizable(false);
        }
        
        @Override
        public void maInitialize()
        {
            super.maInitialize();

            try
            {
                super.editInstance(null, m_model, false);
            }
            catch (Exception e)
            {
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Unable to initialize dialog.", e, true);
            }
        }

        @Override
        public void initUI() throws Exception
        {
            JPartitionPanel panel = new JPartitionPanel("");

            m_name = new JTextField(30);

            panel.addRow("File name", m_name);

            super.getContentPane().add(JPartitionPanel.wrap(panel));
        }

        @Override
        public void initForm() throws Exception
        {
            new JTextFieldAdapter(ModelAspectId.forName("name"), m_name,
                                  EditRule.ALWAYS, null, getMediator());
        }

        //---------------------------------------------------------------------

        public class Model
        {
            private String m_name = null;

            public String getName()
            {
                return m_name;
            }

            public void setName(String name)
            {
                m_name = name;
            }
        }
    }
}