package com.sonicsw.ma.gui.file;

import java.util.HashMap;
/*
 * Copyright (c) 2004 Sonic Software Inc
 *
 * This software is the confidential and proprietary information of Sonic
 * Software. You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the source code
 * license agreement you entered into with Sonic Software.
 *
 */

import javax.swing.Icon;

import com.sonicsw.ma.gui.util.ResourceManager;

/**
 * @author <a href="mailto:sanjeev@progress.com">Sanjeev Kumar</a>
 * @version $Revision$, $Date$, $Author$
 * @since Dec 1, 2006$
 */


class DefaultIconProvider {    
    private static HashMap<String, Icon> iconsCache = new HashMap<String, Icon>();
    
    public static final String TREE_OPEN_ICON = "FolderOpen";
    
    public static final String TREE_CLOSED_ICON = "FolderClosed";
    
    
    private DefaultIconProvider() {
        iconsCache.put(TREE_OPEN_ICON,ResourceManager.getIcon(getClass(), TREE_OPEN_ICON));
        iconsCache.put(TREE_CLOSED_ICON,ResourceManager.getIcon(getClass(), TREE_CLOSED_ICON));
    }

    public Icon getIcon(String name) {
        return (Icon) iconsCache.get(name);
    }

    // Initialization-on-demand holder idiom for Singleton.
    private static class DefaultIconProviderHolder {
        private static final DefaultIconProvider INSTANCE = new DefaultIconProvider();
    }

    public static DefaultIconProvider getInstance() {
        return DefaultIconProviderHolder.INSTANCE;
    }
}
