package com.sonicsw.ma.gui.file;

import javax.swing.Icon;

/**
 * <p>Title: FileAssociation</p>
 * <p>Description: Maintains file association information</p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */

public class FileAssociation
{
    private String    m_strExtension   = null;
    private String    m_strDescription = null;
    private Icon      m_icon           = null;

    /**
     * FileAssociation
     * @param strExt the file extension
     * @param strDescription the file description
     * @param icon the file associations icon
     */
    public FileAssociation(String strExt, String strDescription, Icon icon)
    {
        setExtension(strExt);
        setIcon(icon);
        setDescription(strDescription);
    }

    /**
     * setExtension
     * @param strExt the file extension
     */
    public final void setExtension(String strExt) { m_strExtension = strExt; }

    /**
     * getExtension
     * @return the file extension
     */
    public String getExtension() { return m_strExtension; }

    /**
     * setDescription
     * @param strDescription the file description
     */
    public final void setDescription(String strDescription) { m_strDescription = strDescription; }

    /**
     * getDescription
     * @return the file description
     */
    public String getDescription() { return m_strDescription; }

    /**
     * setIcon
     * @param icon the file associations icon
     */
    public final void setIcon(Icon icon) { m_icon = icon; }

    /**
     * getIcon
     * @return the file associations icon
     */
    public Icon getIcon() { return m_icon; }
}