package com.sonicsw.ma.gui.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import javax.swing.Icon;

import com.sonicsw.ma.gui.util.ResourceManager;

public class FileAssociationManager
{
    private Map m_mapAssociations = new HashMap();
    
    private static class FileAssociationManagerHolder {
        private static final FileAssociationManager INSTANCE = new FileAssociationManager();
    }

    private FileAssociationManager()
    {
        init();
    }

    /**
     * getInstance
     * @return created and maintains a reference to the singleton object.
     */
    public static FileAssociationManager getInstance()
    {
        return FileAssociationManagerHolder.INSTANCE;
    }


    /**
     * getAssociation
     * @param strFilename the filename to ehich the user wants FileAssociation information
     * @return the file's FileAssociation
     * @see FileAssociation
     */
    public static FileAssociation getAssociation(String strFilename)
    {
        // get the file's extension and look it up in the association map...
        String strFileExt = FileElementModel.getFileExtension(strFilename);

        FileAssociation assoc = (FileAssociation)getInstance().m_mapAssociations.get(strFileExt);

        if (assoc == null)
        {
            // association not found, use default.
            assoc = new FileAssociation(strFileExt, strFileExt + " File",
                ResourceManager.getTypeIcon(FileElementPlugin.PLUGIN_TYPE));
        }
        return assoc;
    }

    private void init()
    {
       String[] list = getResourceAssociationNames();

       for (int i = 0; i < list.length; i++)
       {
           String root = "file.assoc." + list[i];

           // grab each file association information block...
           String strExt  = ResourceManager.getString(getClass(), root + ".ext");
           String strDesc = ResourceManager.getString(getClass(), root + ".description");
           String strIcon = ResourceManager.getString(getClass(), root + ".icon");

           // no extension? ignore it.
           if (strExt != null)
           {
               Icon icon = null;

               if (strIcon != null && !strIcon.equals(""))
               {
                   // use defined icon for this association...
                   icon = ResourceManager.getIcon(getClass(), strIcon);
               }
               else
               {
                   //...otherwise use the default icon.
                   icon = ResourceManager.getTypeIcon(FileElementPlugin.PLUGIN_TYPE);
               }

               // add it to the map...
               m_mapAssociations.put(strExt.toUpperCase(),
                    new FileAssociation(strExt.toUpperCase(), strDesc, icon));
           }
       }

    }

    private String[] getResourceAssociationNames()
    {
        String str = ResourceManager.getString(getClass(), "file.assoc.type.list");

        StringTokenizer st = new StringTokenizer(str, ",");

        ArrayList list = new ArrayList();

        while(st.hasMoreTokens())
        {
            list.add(st.nextToken().trim());
        }

        return (String[])list.toArray(new String[0]);
    }
}
