/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.file;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;

public class FileElementDialog extends JPropSheetTabbedDialog
{
    private JTextField m_path             = new JTextField();
    private JTextField m_type             = new JTextField();
    private JTextField m_creationTime     = new JTextField();
    private JTextField m_lastModifiedTime = new JTextField();
    private JTextField m_size             = new JTextField();
    private JTextField m_createdBy        = new JTextField();
    private JCheckBox  m_system           = new JCheckBox();

    public FileElementDialog(JMAFrame parent, String strFilename)
    {
        super(parent, "file-element", FilePluginModel.class);
        setProperties(strFilename);
    }

    private void setProperties(String strFilename) {
        setTitle(strFilename + " " + ResourceManager.getString(getClass(), "dialog.file-element.title"));
    }
    /**
     * Overridden method to initialize the dialog GUI.
     */
    @Override
    public void initUI() throws Exception
    {
        String generalTab = ResourceManager.getString(getClass(), "dialog.file-element.tab.general.label");

        addTabPanel(generalTab, JPartitionPanel.wrap(createGeneralPanel()));
    }

    /**
     * Overridden method to initialize the data for the dialog GUI.
     */
    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("path"),             m_path,             EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"),             m_type,             EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("creationTime"),     m_creationTime,     EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("lastModifiedTime"), m_lastModifiedTime, EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("size"),             m_size,             EditRule.NEVER, new SizeViewValueConverter(), getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("createdBy"),        m_createdBy,        EditRule.NEVER, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"),            m_system,           EditRule.NEVER, null, getMediator());
    }

    private JPanel createGeneralPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");

        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.path.label"),             m_path);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.type.label"),             m_type);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.creationTime.label"),     m_creationTime);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.lastModifiedTime.label"), m_lastModifiedTime);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.size.label"),             m_size);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.createdBy.label"),        m_createdBy);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.system.label"),        m_system);

        return panel;
    }

    class SizeViewValueConverter implements ViewValueConverter
    {
        @Override
        public Object viewValueToModel(Object viewValue)
            throws ViewValueConversionException
        {
            Object modelValue = null;

            try
            {
                if (viewValue != null)
                {
                    viewValue = Long.valueOf(viewValue.toString());
                }
            }
            catch (Exception e)
            {
                throw new ViewValueConversionException("Value is not a long!", e, ModelAspectId.forName("size"));
            }

            return modelValue;
        }

        @Override
        public Object modelValueToView(Object modelValue)
            throws ViewValueConversionException
        {
            if (modelValue != null)
            {
                if (((Long)modelValue).longValue() == 0)
                {
                    return "1";
                }

                return modelValue.toString();
            }

            return null;
        }

        @Override
        public String[] getViewStringValues() { return null; }
        @Override
        public boolean isViewValueToModelSupported() { return true; }

        @Override
        public Class getModelClass() { return Long.class; }
        @Override
        public Class getViewClass()  { return String.class; }
    }
}
