/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.file;

import javax.swing.Icon;

import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;

public class FileElementModel
{
    private IConfigBeanFile m_bean;

    public FileElementModel(IConfigBeanFile bean)
    {
        m_bean = bean;
    }

    public void refresh()
    throws ConfigServiceException {
        m_bean.refresh();
    }

    public String getName()
    {
        String name = m_bean.getName();

        return name.substring(name.lastIndexOf("/") + 1);
    }

    public String getPath()
    {
        if(m_bean == null)
        {
            return null;
        }

        String strResult = m_bean.getName();

        int index = strResult.lastIndexOf("/");

        if (index != -1)
        {
            strResult = strResult.substring(0, index + 1);
        }

        return strResult;
    }

    public Long getSize()
    {
        return (m_bean != null) ? new Long(m_bean.getFileSize()) : null;
    }

    public String getLastModifiedTime()
    {
        if(m_bean == null)
        {
            return null;
        }

        return Helper.getDateTimeString(new Long(m_bean.getLastModifiedTime()));
    }

    public String getCreationTime()
    {
        if(m_bean == null)
        {
            return null;
        }

        return Helper.getDateTimeString(new Long(m_bean.getCreationTime()));
    }

    public String getCreatedBy()
    {
        return (m_bean != null) ? m_bean.getCreateBy() : null;
    }

    public String getType()
    {
        return (m_bean != null) ? FileAssociationManager.getAssociation(m_bean.getName()).getDescription() : "Unknown";
    }

    public Icon getTypeIcon()
    {
        return (m_bean != null) ? FileAssociationManager.getAssociation(m_bean.getName()).getIcon() : null;
    }

    public static String getFileExtension(String strFilename)
    {
        String fileExt = new String("");

        int index = strFilename.lastIndexOf('.');

        if(index != -1)
        {
            fileExt = strFilename.substring(index + 1).toUpperCase();
        }

        return fileExt.trim();
    }
}
