/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.file;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;

/**
 * FileFolderDialog
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */
public class FileFolderDialog extends JPropSheetTabbedDialog
{
    private JTextField m_path   = new JTextField();
    private JTextField m_type   = new JTextField();
    private JCheckBox  m_system = new JCheckBox();

    public FileFolderDialog(JMAFrame parent, String strFolderName)
    {
        this(parent, "file-element", FileFolderPluginModel.class);
        setProperties(strFolderName);
    }

    private void setProperties(String strFolderName) {
        if (strFolderName != null)
        {
            setTitle(strFolderName + " " + ResourceManager.getString(getClass(), "dialog.file-element.title"));
        }
    }
    
    public FileFolderDialog(JMAFrame parent, String name, Class modelClass)
    {
        super(parent, name, modelClass);
    }

    protected JPanel createGeneralPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");

        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.path.label"),   m_path);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.type.label"),   m_type);
        panel.addRow(ResourceManager.getString(getClass(), "dialog.file-element.system.label"), m_system);

        return panel;
    }

    /**
     * Overridden method to initialize the dialog GUI.
     */
    @Override
    public void initUI() throws Exception
    {
        String generalTab = ResourceManager.getString(getClass(), "dialog.file-element.tab.general.label");

        addTabPanel(generalTab, JPartitionPanel.wrap(createGeneralPanel()));
    }

    /**
     * Overridden method to initialize the data for the dialog GUI.
     */
    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("path"),  m_path,   EditRule.NEVER, null, getMediator());
        new JTextFieldAdapter(ModelAspectId.forName("type"),  m_type,   EditRule.NEVER, null, getMediator());
        new JCheckBoxAdapter(ModelAspectId.forName("system"), m_system, EditRule.NEVER, null, getMediator());
    }
}
