/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.action.ExportPluginAction;
import com.sonicsw.ma.gui.config.ConfigFolderPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IPlugin;

public class ImportFileAction extends BasicPluginAction
{
    public ImportFileAction(IPlugin plugin)
    {
        super(plugin,"file.import");
    }

    @Override
    public boolean isEnabled()
    {
        return getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        Thread t = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                PreferenceManager pm = PreferenceManager.getInstance();
        
                JFileChooser fc = new JFileChooser();
        
                fc.setDialogTitle("Select Import File");
                fc.setMultiSelectionEnabled(true);
                fc.setCurrentDirectory(new File(pm.getString(ExportPluginAction.BOOT_PATH_PREFS, ExportPluginAction.BASEPATH, "")));
                fc.setApproveButtonText("Import");
                
        
                if(fc.showOpenDialog(MgmtConsole.getMgmtConsole()) == JFileChooser.APPROVE_OPTION)
                {
                    File[] files = fc.getSelectedFiles();
                    for (int i = 0; i < files.length; i++)
                    {
                        String fullPath = files[i].getPath();//.getSelectedFile().getPath();
                        int    index    = fullPath.lastIndexOf(File.separator);
                        String path     = fullPath.substring(0, index + 1);
                        String name     = fullPath.substring(index + 1);
            
                        String strPathName = AbstractFilePlugin.buildFilePath(getPlugin().getPluginPath(), name);
            
                        if (i == 0)
                        {
                            // Store the base path in the preferences so that we can default
                            // to the same file path the next time
                            pm.setString(ExportPluginAction.BOOT_PATH_PREFS, ExportPluginAction.BASEPATH, path, true);
                        }
                        if (validateFile(fullPath)) {
                        	((ConfigFolderPlugin)getPlugin()).addFile(new File(fullPath), name, false);
						}
                    }
                }
            }
            
            /*
             * MQ-35127: validate xml and xsl files.
             * invoked when importing files from SMC -> Import File
             * If files are valid then import 
             * else throw a dialog for force import.
             * To support this new behaviour, introducing a new system property
             * "sonicsw.import.validate.xml.xsl" should be set to true for validation 
             */
            private boolean validateFile(String fullPath) {
            	boolean result = false;
            	if (fullPath != null && (fullPath.endsWith(".xsl") || fullPath.endsWith(".xml"))
            			&& Boolean.getBoolean("sonicsw.import.validate.xml.xsl")) {
            		try {
            			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            			DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            			Document doc = dBuilder.parse(fullPath);
            			result = true;
            		} catch (ParserConfigurationException | SAXException | IOException e) {
            			int doImport = JOptionPane.showConfirmDialog(MgmtConsole.getMgmtConsole(),
            					"Validation failed for file " + fullPath, "Do you still want to import",
            					JOptionPane.YES_NO_OPTION);
            			if (doImport == JOptionPane.YES_OPTION) {
            				result = true;
            			}
            		}
            	} else {
            		result = true;
            	}
            	return result;
            }
        });

        t.start();
    }
}