package com.sonicsw.ma.gui.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;

import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.IAssociationEditor;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.EditorInfo;
import com.sonicsw.ma.plugin.FileAssociationToolInfo;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.util.FileTrackerHandler;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSFileSystem;

public class OpenFileAction extends BasicPluginAction
{
    public OpenFileAction(IPlugin plugin)
    {
        super(plugin, "file.open");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (getTargetAction() != null)
        {
            super.actionPerformed(event);
        }
        else
        {
            if(!(getPlugin() instanceof FileElementPlugin))
            {
                return;
            }

            Thread t = new Thread(new Runnable()
            {
                @Override
                public void run()
                {
                    FileElementPlugin pluginFE = (FileElementPlugin)getPlugin();
                    String filename = pluginFE.getPluginPath();

                    try
                    {
                        if (pluginFE.pathExists(pluginFE.getPluginPath()))
                        {
                            final IPluginContext context = pluginFE.getPluginContext();
                            final IConfigServer server = context.getConfigContext().getConfigServer();
                            final IConfigBeanFile bean = pluginFE.getFileByPath(pluginFE.getPluginPath());

                            String extn = FileElementModel.getFileExtension(pluginFE.getPluginName());

                            // First check to see if we have a built in editor
                            // for this file extension
                            HashMap editors  = context.getLibrary().getEditorsMap();
                            EditorInfo eInfo = (EditorInfo)editors.get(extn.toLowerCase());

                            if(eInfo != null)
                            {
                                // We have a built in editor
                                Object editor = null;

                                try
                                {
                                    Class cls = Class.forName(eInfo.getClassName(), false, eInfo.getClassLoader());
                                    editor = cls.newInstance();
                                }
                                catch(Throwable e)
                                {
                                    throw new Exception("Failed to create editor with class '" + eInfo.getClassName() + "'", e);
                                }

                                if(!(editor instanceof IAssociationEditor))
                                {
                                    throw new Exception("'" + eInfo.getClassName() + "' is not a valid editor");
                                }

                                IAssociationEditor iEditor = (IAssociationEditor)editor;

                                iEditor.aeInit(new SonicFSFileSystem(context.
                                        getConnectionInfo().getDirectoryService(),
                                        context.getConnectionInfo().getUserName()),
                                        null);

                                iEditor.aeOpenFile(pluginFE.getPluginPath());
                            }
                            else
                            {
                                // Use a OS file associated editor

                                // create a temp file and export the data to it...
                                File fileTemp = File.createTempFile("sfs", "." + extn);
                                // We want the temporary file to go away when the VM shuts down
                                fileTemp.deleteOnExit();
                                pluginFE.exportFile(fileTemp);

                                // launch the associated editor...
                                FileAssociationToolInfo tool = new FileAssociationToolInfo(fileTemp);

                                tool.execute(new FileTrackerHandler(fileTemp)
                                {
                                    @Override
                                    public void fileModified()
                                    {
                                        FileInputStream stream = null;

                                        try
                                        {
                                            stream = new FileInputStream(getFile());
                                            bean.setContents(stream);
                                        }
                                        catch (Exception e)
                                        {
                                            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                                                "Failed to update local file", e, true);
                                        }
                                        finally
                                        {
                                            if (stream != null)
                                            {
                                                try { 
                                                    stream.close(); 
                                                } catch (Exception e) { 
                                                    e.printStackTrace();
                                                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                                                }
                                                stream = null;
                                            }
                                        }
                                    }

                                    @Override
                                    public void fileFinished(int exitCode)
                                    {
                                        super.fileFinished(exitCode);

                                        try
                                        {
                                            if (bean.isModified())
                                            {
                                                int ok = MgmtConsole.getMgmtConsole().showConfirmDialog(
                                                    "The file has been modified. Do you want to store these changes back into the Directory Service?",
                                                    "Edit Confirmation",
                                                    JOptionPane.QUESTION_MESSAGE,
                                                    JOptionPane.YES_NO_OPTION);

                                                if(ok == JOptionPane.YES_OPTION)
                                                {
                                                    server.storeConfigElement(bean);
                                                }
                                                else
                                                {
                                                    bean.refresh();
                                                }
                                            }
                                        }
                                        catch (Exception e)
                                        {
                                            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                                                "Unable to persist file changes to the DS", e, true);
                                        }
                                    }
                                });
                            }
                        }
                    }
                    catch (Throwable e)
                    {
                        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                            "Unable to edit file: " + ((filename != null) ? filename : ""), e, true);
                    }
                }
            });

            t.start();
        }
    }

    @Override
    public boolean isEnabled()
    {
        return canDisplay();
    }

    @Override
    public boolean canDisplay()
    {
        // on windows platforms we always enable the open menu item
        if(Helper.isWindowsPlatform())
        {
            return true;
        }

        // on other platforms we need to enable the 'open' command if there
        // is a built in associated editor for the file extension

        String extn = FileElementModel.getFileExtension(getPlugin().getPluginName());

        if(getPlugin().getPluginContext().getLibrary().getEditorsMap().get(extn.toLowerCase()) != null)
        {
            return true;
        }

        return false;
    }
}