/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.messagelog;

import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JLabelAdapter;
import modelobjects.framework.swing.JTextAreaAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;

public class JMessageDialog extends JPropSheetTabbedDialog
{
    private JLabel     m_type = new JLabel();
    private JTextArea  m_message = new JTextArea(10, 32);
    private JTextArea  m_throwable = new JTextArea(10, 32);
    private JTextField m_time = new JTextField(32);


    public JMessageDialog(JMAFrame parent)
    {
        super(parent, "message.log.details", MessageRowModel.class);
    }

    private JPanel createGeneralPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "");

        m_message.setWrapStyleWord(true);
        m_message.setLineWrap(true);

        panel.addRow("Type",    m_type);
        panel.addRow("Time",    m_time);
        panel.addRow("Message", new ExtendedJScrollPane(m_message));

        return panel;
    }

    private JPanel createTracePanel()
    {
        JPartitionPanel panel = new JPartitionPanel(true, "r", null);

        panel.add(new ExtendedJScrollPane(m_throwable));

        return panel;
    }

    @Override
    protected void initUI() throws Exception
    {
        addTabPanel("General", JPartitionPanel.wrap(createGeneralPanel()));

        MessageRowModel model = (MessageRowModel)getModel();

        // Only add (show) the trace tab if a throwable trace was stored...
        //
        if ((model != null) && (model.getThrowable() != null))
        {
            addTabPanel("Trace", createTracePanel());
        }
    }

    @Override
    protected void initForm() throws Exception
    {
        new JTypeLabelAdapter(ModelAspectId.forName("typeInteger"),
                              m_type, null, getMediator());

        new JTextAreaAdapter(ModelAspectId.forName("message"),
                              m_message, EditRule.NEVER, null, getMediator());

        new JTextFieldAdapter(ModelAspectId.forName("time"),
                              m_time, EditRule.NEVER,
                              new DateLongToStringConverter(), getMediator());

        if (m_throwable != null)
        {
            new JTextAreaAdapter(ModelAspectId.forName("throwableString"),
                                 m_throwable, EditRule.NEVER, null, getMediator());
        }
    }

    @Override
    public Action[] getButtonActions()
    {
        return new Action[]
        {
            new CloseAction(getDefaultCancelAction()),
        };
    }

    public class CloseAction extends BasicGuiAction
    {
        public CloseAction(Action targetAction)
        {
            super("dialog.close", targetAction);
        }
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    public class JTypeLabelAdapter extends JLabelAdapter
    {
        public JTypeLabelAdapter(ModelAspectId modelAspectId,
                                 JLabel viewComponent,
                                 ViewValueConverter viewValueConverter,
                                 ModelEditMediator modelEditMediator)
        {
            super(modelAspectId, viewComponent, viewValueConverter, modelEditMediator);
        }

        @Override
        protected void setViewAspectValue(Object viewAspectValue)
            throws IllegalArgumentException
        {
            if (viewAspectValue == null)
            {
                ((JLabel)getViewComponent()).setText(null);
                ((JLabel)getViewComponent()).setIcon(null);
            }
            else if (viewAspectValue instanceof Integer)
            {
                int value = ((Integer)viewAspectValue).intValue();

                ((JLabel)getViewComponent()).setText(MessageTableModel.logTypeToString(value));
                ((JLabel)getViewComponent()).setIcon(MessageTableModel.logTypeToIcon(value));
            }
            else
            {
                throw new IllegalArgumentException("value must be a Integer");
            }
        }

    }

    //-------------------------------------------------------------------------

    public class DateLongToStringConverter implements ViewValueConverter
    {
        @Override
        public Object viewValueToModel(Object viewValue)
            throws ViewValueConversionException
        {
            return null;
        }

        @Override
        public Object modelValueToView(Object modelValue)
            throws ViewValueConversionException
        {
            if (modelValue == null)
            {
                return "";
            }

            if (modelValue instanceof Long)
            {
                return Helper.getDateTimeString((Long)modelValue);
            }
            throw new ViewValueConversionException("Failed to convert value: " + modelValue);
        }

        @Override
        public String[] getViewStringValues()
        {
            return null;
        }

        @Override
        public boolean isViewValueToModelSupported()
        {
            return true;
        }

        @Override
        public Class getModelClass()
        {
            return Long.class;
        }

        @Override
        public Class getViewClass()
        {
            return String.class;
        }
    }
}
