/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.messagelog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.PopupMenuShower;
import com.sonicsw.ma.gui.util.ResourceManager;

public class JMessageInternalFrame extends JMAInternalFrame implements MouseListener
{
    private JRowTable m_table;

    public JMessageInternalFrame(MessageTableModel model)
    {
        super("message.viewer");
        setFrameIcon();
        m_table = new JRowTable(model, getClass().getName());
        m_table.addMouseListener(this);
    }
    
    private void setFrameIcon() {
        setFrameIcon(ResourceManager.getIcon(getClass(), "MessageLog"));
    }

    @Override
    public void maInitialize()
    {
        getContentPane().add(new ExtendedJScrollPane(m_table));

        // add the popup menu
        JPopupMenu popup = new JPopupMenu();

        popup.add(new JBasicMenuItem(new ClearAllAction()));
        popup.add(new JBasicMenuItem(new ClearSelectedAction()));
        popup.add(new JBasicMenuItem(new PropertiesAction()));

        popup.addPopupMenuListener(new PopupMenuListener()
        {
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e)
            {
                Component[] components = ((JPopupMenu)e.getSource()).getComponents();

                for (int i = 0; i < components.length; i++)
                {
                    if (components[i] instanceof AbstractButton)
                    {
                        Action action = ((AbstractButton)components[i]).getAction();

                        if (action != null)
                        {
                            components[i].setEnabled(action.isEnabled());
                        }
                    }
                }
            }
            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) { }
            @Override
            public void popupMenuCanceled(PopupMenuEvent e) { }
        });
        m_table.addMouseListener(new PopupMenuShower(m_table, popup));
    }

    @Override
    public void maCleanup()
    {
        if (m_table != null)
        {
            m_table.cleanup();
        }
        m_table = null;
    }

    @Override
    public void mouseClicked(MouseEvent evt)
    {
        if (evt.getClickCount() == 2)
        {
            int row = m_table.rowAtPoint(evt.getPoint());

            if (row >= 0)
            {
                launchDialog(row);
            }
        }
    }

    private void launchDialog(final int row)
    {
        try
        {
            JMessageDialog dialog = new JMessageDialog(MgmtConsole.getMgmtConsole());
            dialog.editInstance(null, ((IModelTableModel)m_table.getModel()).getRowModel(row), false);
            dialog.setVisible(true);
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "Error launching dialog", e, true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {}
    @Override
    public void mouseExited(MouseEvent evt) {}
    @Override
    public void mousePressed(MouseEvent evt) {}
    @Override
    public void mouseReleased(MouseEvent evt) {}

    //-------------------------------------------------------------------------
    // Inner classes
    //-------------------------------------------------------------------------

    class ClearAllAction extends BasicGuiAction
    {
        ClearAllAction()
        {
          super("message.viewer.clear.all");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            if (MgmtConsole.getMgmtConsole().showConfirmDialog(
                "Are you sure you want to clear all messages",
                "Clear Messages",
                JOptionPane.QUESTION_MESSAGE,
                JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
            {
                JWaitCursor wc = new JWaitCursor(JMessageInternalFrame.this);

                try
                {
                    ((IModelTableModel)m_table.getModel()).clear();
                }
                finally
                {
                    wc.release();
                }
            }
        }
    }

    class ClearSelectedAction extends BasicGuiAction
    {
        ClearSelectedAction()
        {
          super("message.viewer.clear.selected");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            JWaitCursor wc = new JWaitCursor(JMessageInternalFrame.this);

            try
            {
                int[] rows = m_table.getSelectedRows();

                for (int i = rows.length - 1; i >= 0; i--)
                {
                    ((IModelTableModel)m_table.getModel()).deleteRow(rows[i]);
                }
            }
            finally
            {
                wc.release();
            }
        }

        @Override
        public boolean isEnabled()
        {
            int[] rows = m_table.getSelectedRows();

            return rows.length > 0;
        }
    }

    class PropertiesAction extends BasicGuiAction
    {
        PropertiesAction()
        {
          super("message.viewer.properties");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            int[] rows = m_table.getSelectedRows();

            if (rows.length > 0)
            {
                launchDialog(rows[0]);
            }
        }

        @Override
        public boolean isEnabled()
        {
            int[] rows = m_table.getSelectedRows();

            return rows.length == 1;
        }
    }
}
