/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.messagelog;

import java.io.PrintWriter;
import java.io.StringWriter;

import com.sonicsw.ma.gui.MgmtConsole;

public class MessageRowModel
{
    protected int       m_type;
    protected String    m_domain;
    protected String    m_message;
    protected Throwable m_throwable;
    protected long      m_time;

    MessageRowModel(int type, String domain, String message, Throwable throwable)
    {
        m_type      = type;
        m_domain    = domain;
        m_message   = message;
        m_throwable = throwable;
        m_time      = System.currentTimeMillis();
    }

    public Integer getTypeInteger()
    {
        return new Integer(m_type);
    }

    public String getDomain()
    {
        return m_domain;
    }

    public String getMessage()
    {
        return m_message;
    }

    public Throwable getThrowable()
    {
        return m_throwable;
    }

    public String getThrowableString()
    {
        StringWriter sw = new StringWriter();
        PrintWriter  pw = new PrintWriter(sw, true);

        if (m_throwable != null)
        {
            MgmtConsole.printExceptionInfo(m_throwable, pw);
        }

        return sw.toString();
    }

    public long getTime()
    {
        return m_time;
    }

    @Override
    public String toString()
    {
        StringBuffer res = new StringBuffer();

        res.append(MessageTableModel.logTypeToString(m_type)).append('\t');

        if (m_domain != null)
        {
            res.append(m_domain);
        }
        res.append('\t');

        if (m_message != null)
        {
            res.append(m_message);
        }
        res.append('\t');

        res.append(m_time);

        return res.toString();
    }

}

