package com.sonicsw.ma.gui.perms;

public abstract class AbstractPermissions {

    private Principal principal;
    private int scope;
    protected int permissions;


    public AbstractPermissions(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return principal;
    }

    @Override
    public String toString() {
        return getPrincipal().getName();
    }

    public int getScopeBits() {
        return scope;
    }

    public void setScopeBits(int scope) {
        this.scope = scope;
    }


    public int getPermissionsBits() {
        return permissions;
    }

    public void setPermissionsBits(int perms) {
        permissions = perms;
    }

    /**
     * The perm should be a SINGLE permission & not a combination.
     * @param perm
     */
    public void removePermissionBit(int perm) {
        _removePermissionBits(perm);
        handlePermRemoved(perm);
    }

    protected void _removePermissionBits(int perm) {
        permissions = permissions & ~perm;
    }

    /**
     * The perm should be a SINGLE permission & not a combination.
     * ie, perm should be 2<sup>n</sup>
     * @param perm
     */
    public void addPermissionBit(int perm) {
        _addPermissionBits(perm);
        handlePermAdded(perm);
    }

    protected void _addPermissionBits(int perm) {
        permissions = permissions | perm;
        _removePermissionBits(notOf(perm));
    }

    protected void handlePermAdded(int perm) {
    }

    protected void handlePermRemoved(int perm) {
    }

    protected int notOf(int perms) {
        int not=0,position=1;
        for(int i=1;i<=perms;i<<=1,position++){
            if((i&perms)>0){
                if(position%2==1)
                {
                    not = not | i << 1;  //  its an allow, travel forward by 1 to find deny
                }
                else {
                    not = not | i >> 1;  //  its a deny, travel backward by 1 to find allow
                }
                i<<=1;
                position++;
            }
        }
        return not;
    }

    public String toDetailedString(){
        return (getClass().getName()+"::{Principal :"+toString()+", Scope :"+getScopeDisplayName()+", Perms :"+getPermsDisplayName()+"}");
    }

    protected String nameFrom(PermissionsList.ScopeType[] scopeTypes){
        int scopeBits = getScopeBits();
        for (int i = 0; i < scopeTypes.length; i++) {
            PermissionsList.ScopeType folderScopeType = scopeTypes[i];
            if(scopeBits==folderScopeType.getBits())
            {
                return folderScopeType.getDisplayName();
            }
        }
        return null;
    }



    protected abstract String getScopeDisplayName();
    protected abstract String getPermsDisplayName();


    public static class Principal {
        private String name;
        private boolean isUser;

        public Principal(String name, boolean isUser) {
            this.name = name;
            this.isUser = isUser;
        }

        public String getName() {
            return name;
        }

        public boolean isUser() {
            return isUser;
        }

        public boolean isGroup() {
            return !isUser;
        }

    }
}
