package com.sonicsw.ma.gui.perms;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.swing.SwingUtilities;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.plugin.IPlugin;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.security.InvalidManagementPermissionException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.common.security.ManagementPermissionFactory;

/**
 * @author <a href="mailto:murali@sonicsoftware.com">Murali Mohan</a>
 * @since: Sep 13, 2006
 */
public class ConfigurePermsAction extends BasicPluginAction {

    public static final String MGMT_SECURITY_CONFIG = "mgmtsecurity.config";
    protected static ManagementPermissionFactory factory = new ManagementPermissionFactory();

    protected IPlugin plugin;
    protected String[] paths;
    protected List b4SessionPerms;


    public ConfigurePermsAction(IPlugin plugin, String path) {
        this(plugin, path, MGMT_SECURITY_CONFIG);
    }

    public ConfigurePermsAction(IPlugin plugin, String path, String displaType) {
        super(displaType);
        this.plugin = plugin;
        this.paths = new String[]{path};
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PermissionsList permsModel = makePermListModel();
        if(permsModel==null)
        {
            return;
        }
        b4SessionPerms = permsModel.getPermissions();
        final PermissionsDialog perms = new PermissionsDialog(plugin, permsModel, MgmtConsole.getMgmtConsole(), getDisplayType());
        perms.setVisible(true);
        if (perms.getCloseCommand() == JMADialog.CLOSE_OK)
        {
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    applyChanges(perms.getModel());
                }

            });
        }

    }


    private PermissionsList makePermListModel() {
        IDirectoryFileSystemService ds = plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        PermissionsList permissionsList = makePermsList();
        try {
            IManagementPermission[][] managementPermissions = getPermsFromDS(ds);
            List perms = new ArrayList();
            for (int i = 0; i < managementPermissions[0].length; i++) {
                IManagementPermission mgmtPerm = managementPermissions[0][i];
                String principal = mgmtPerm.getPrincipal();
                AbstractPermissions.Principal princi = new AbstractPermissions.Principal(principal, mgmtPerm.getPrincipalType() == IManagementPermission.USER_PRINCIPAL_TYPE);
                AbstractPermissions aPerms = makePerms(princi);
                aPerms.setPermissionsBits(mgmtPerm.getPermissions());
                aPerms.setScopeBits(mgmtPerm.getScope());
                perms.add(aPerms);
            }
            permissionsList.setPermissions(perms);
        } catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_WARNING,"Retrieving Permissions information failed",e,true);
            permissionsList = null;
        }
        return permissionsList;
    }



    private void applyChanges(PermissionsList model) {
        List aftSessionPerms = model.getPermissions();
        String[][] removedPrincis = new String[1][];
        removedPrincis[0] = getRemovedPrincis(b4SessionPerms,aftSessionPerms);

        IManagementPermission[][] ipermissions = new IManagementPermission[1][aftSessionPerms.size()];
        for (int i = 0; i < aftSessionPerms.size(); i++) {
            AbstractPermissions perms = (AbstractPermissions) aftSessionPerms.get(i);
            String principalName = perms.getPrincipal().getName();
            short principalType = perms.getPrincipal().isUser() ? IManagementPermission.USER_PRINCIPAL_TYPE : IManagementPermission.GROUP_PRINCIPAL_TYPE;
            ipermissions[0][i] = factory.createManagementPermission(principalName, principalType, perms.getScopeBits(), perms.getPermissionsBits());
        }
        IDirectoryFileSystemService ds = plugin.getPluginContext().getConnectionInfo().getDirectoryService();
        try {
            if (removedPrincis[0].length > 0){
                removePermsOnDS(ds,removedPrincis);
            }
            if (ipermissions[0].length > 0){
                addOrUpdatePermsOnDS(ds, ipermissions);
            }
        } catch (DirectoryServiceException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,"Failed to set permissions:",e,true);
        } catch (InvalidManagementPermissionException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,"Failed to set permissions:",e,true);
        } catch (ManagementPermissionDeniedException e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,"Failed to set permissions:",e,true);
        }
    }

    /**
     * removed are the ones in b4 & not in aft
     * @param b4SessionPerms
     * @param aftSessionPerms
     * @return
     */
    private String[] getRemovedPrincis(List b4SessionPerms, List aftSessionPerms) {
        List removed = new ArrayList();
        String[] afts = new String[aftSessionPerms.size()];
        for (int i = 0; i < aftSessionPerms.size(); i++) {
            AbstractPermissions aft =  (AbstractPermissions) aftSessionPerms.get(i);
            afts[i] = aft.getPrincipal().getName();
        }
        Arrays.sort(afts);
        for (Iterator iterator = b4SessionPerms.iterator(); iterator.hasNext();) {
            AbstractPermissions b4 =  (AbstractPermissions) iterator.next();
            String name = b4.getPrincipal().getName();
            if(Arrays.binarySearch(afts,name)<0)
            {
                removed.add(name);
            }
        }
        return (String[]) removed.toArray(new String[removed.size()]);
    }


    protected void addOrUpdatePermsOnDS(IDirectoryFileSystemService ds, IManagementPermission[][] ipermissions) throws DirectoryServiceException, InvalidManagementPermissionException {
        ((IManagementSecurityConfigurator)ds).setManagementPermissions(paths, getType(), ipermissions);
    }

    protected void removePermsOnDS(IDirectoryFileSystemService ds, String[][] principals) throws DirectoryServiceException, InvalidManagementPermissionException {
        ((IManagementSecurityConfigurator)ds).removeManagementPermissions(paths, getType(), principals);
    }

    protected IManagementPermission[][] getPermsFromDS(IDirectoryFileSystemService ds) throws DirectoryServiceException {
        return ((IManagementSecurityConfigurator)ds).getManagementPermissions(paths, getType());
    }

    protected String getDisplayType() {
        return MGMT_SECURITY_CONFIG;
    }

    protected String getType() {
        return IManagementPermission.CONFIGURE_TYPE;
    }

    protected PermissionsList makePermsList() {
        return new PermissionsList.ConfigurePermissionsList(plugin);
    }

    protected AbstractPermissions makePerms(AbstractPermissions.Principal princi) {
        return new ConfigurePermissions(princi);
    }


}
