package com.sonicsw.ma.gui.perms;

import com.sonicsw.ma.plugin.IPlugin;

import com.sonicsw.mf.common.security.IManagementPermission;

/**
 * @author <a href="mailto:murali@sonicsoftware.com">Murali Mohan</a>
 * @since: Sep 13, 2006
 */
public class ManagePermsAction extends ConfigurePermsAction {

    public static final String MGMT_SECURITY_MANAGE = "mgmtsecurity.manage";

    public ManagePermsAction(IPlugin plugin, String path) {
        super(plugin, path,MGMT_SECURITY_MANAGE);
    }

    @Override
    protected String getDisplayType() {
        return MGMT_SECURITY_MANAGE;
    }

    @Override
    protected String getType() {
        return IManagementPermission.MANAGE_TYPE;
    }


    @Override
    protected PermissionsList makePermsList() {
        return new PermissionsList.ManagePermissionsList(plugin);
    }

    @Override
    protected AbstractPermissions makePerms(AbstractPermissions.Principal princi) {
        return new ManagePermissions(princi);
    }

}
