package com.sonicsw.ma.gui.perms;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.PrincipalChooserDialog;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;

public class PermissionsDialog extends JMADialog {



    private JList principalsList;
    private DefaultListModel listModel;

    private JButton addButton;
    private JButton deleteButton;

    private JComboBox scopesCombo;
    private JCheckBox[][] permissionChx;
    private static final String chkBoxBit = PermissionsDialog.class.getName() + ".checkBoxBit";

    private PermissionsList permsModel;

    // currently edited perm
    private AbstractPermissions current;
    //  whether the view is rendering. So the listeners need not react.
    private boolean itsMe = false;
    private IPlugin plugin;
    private PermissionsDialog.MyOKAction okAction = new MyOKAction();

    public PermissionsDialog(IPlugin plugin, PermissionsList perms, JMAFrame parent, String name) {
        super(parent, name);
        this.plugin = plugin;
        this.permsModel = perms;
    }

    @Override
    protected void maInitialize() {
        Container contentPane = getContentPane();
        JPanel topPanel = new JPanel(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE);
        gbc.gridx=0;
        gbc.gridy=0;
        gbc.weightx=1;
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.anchor=GridBagConstraints.NORTH;
        topPanel.add(makePrincipalsPanel(),gbc);
        gbc.gridy++;
        topPanel.add(makeScopesPanel(),gbc);
        gbc.gridy++;
        gbc.weighty=1;
        topPanel.add(makePermsPanel(),gbc);
        contentPane.add(topPanel);

        // now set the model on the UI
        listModel = new SortedListModel(permsModel.getPermissions(),new PermissionsDialog.PrincipalsComparator());
        principalsList.setModel(listModel);
        scopesCombo.setModel(new DefaultComboBoxModel(permsModel.getAvailableScopeTypes()));
        if (!listModel.isEmpty()) {
            principalsList.setSelectedIndex(0);
        } else {
            renderDetails(current); //  current is null, so details will be disabled
        }
        deleteButton.setEnabled(!listModel.isEmpty());
        okAction.setEnabled(false);
    }



    @Override
    protected void maCleanup() {
    }

    @Override
    public Action[] getButtonActions() {
        return new Action[] {
                okAction,
                getDefaultCancelAction()
        };
    }

    public PermissionsList getModel() {
        List list = Arrays.asList(listModel.toArray());
        permsModel.setPermissions(list);
        return permsModel;
    }

    private JPanel makePermsPanel() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder("Permissions"));

        JLabel allow = new JLabel("Allow");
        Font font = topPanel.getFont();
        JLabel deny = new JLabel("Deny");

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE,JPartitionPanel.DEFAULT_GAP_SIZE);
        gbc.gridx=0;
        gbc.gridy=0;
        gbc.weightx=1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        topPanel.add(new JLabel(),gbc);
        gbc.gridx++;
        gbc.weightx=0.01;
        topPanel.add(allow,gbc);
        gbc.gridx++;
        topPanel.add(deny,gbc);

        PermissionsList.PermissionType[] permissionTypes = permsModel.getAvailablePermissionTypes();
        permissionChx = new JCheckBox[permissionTypes.length][2];
        ActionListener l = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (itsMe)
                {
                    return;
                }
                itsMe = true;
                try {
                    JCheckBox source = (JCheckBox) e.getSource();
                    if(source.isSelected())
                    {
                        current.addPermissionBit(((Integer) source.getClientProperty(chkBoxBit)).intValue());
                    }
                    else
                    {
                        current.removePermissionBit(((Integer) source.getClientProperty(chkBoxBit)).intValue());
                    }
                    renderPerms(current);
                    modelChanged();
                } finally {
                    itsMe = false;
                }
            }
        };
        for (int i = 0; i < permissionTypes.length; i++) {
            gbc.gridy++;
            String permissionName = permissionTypes[i].name;
            permissionChx[i][0] = new JCheckBox();
            permissionChx[i][0].putClientProperty(chkBoxBit, new Integer(permissionTypes[i].allowBit));
            permissionChx[i][0].addActionListener(l);
            permissionChx[i][1] = new JCheckBox();
            permissionChx[i][1].putClientProperty(chkBoxBit, new Integer(permissionTypes[i].denyBit));
            permissionChx[i][1].addActionListener(l);
            gbc.gridx=0;
            topPanel.add(new JLabel(permissionName),gbc);
            gbc.gridx++;
            topPanel.add(permissionChx[i][0],gbc);
            gbc.gridx++;
            topPanel.add(permissionChx[i][1],gbc);

        }
        return topPanel;
    }

    private JPartitionPanel makeScopesPanel() {
        JPartitionPanel topPanel = new JPartitionPanel(false, "p,r", null);
        scopesCombo = new JComboBox();
        scopesCombo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (itsMe)
                {
                    return;
                }
                PermissionsList.ScopeType selectedItem = (PermissionsList.ScopeType) scopesCombo.getSelectedItem();
                current.setScopeBits(selectedItem.getBits());
                modelChanged();
            }
        });
        topPanel.addRow("Scope", scopesCombo);
        return topPanel;
    }

    private JPartitionPanel makePrincipalsPanel() {
        JPartitionPanel topPanel = new JPartitionPanel(false, "r", "Principals");
        principalsList = new JList();
        principalsList.setCellRenderer(new PrincipalCellRenderer());
        principalsList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        principalsList.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting())
                {
                    return;
                }
                int index = principalsList.getSelectedIndex();
                current = (index >= 0) ? (AbstractPermissions) listModel.getElementAt(index) : null;
                renderDetails(current);
            }

        });
        JScrollPane membersScroll = new ExtendedJScrollPane(principalsList);
        Dimension pref = principalsList.getPreferredScrollableViewportSize();
        membersScroll.setPreferredSize(pref);
        membersScroll.setMinimumSize(pref);

        addButton = new JButton("Add...");
        addButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Set domainUsers = Utils.getDomainUsers(ManagementSecurityUtils.getSecurityDomain(plugin),plugin.getPluginContext().getConfigContext().getConfigServer(),true);
                removeExistingPrincipals(domainUsers,true);
                Object users[] = domainUsers.toArray();
                Set domainGrps = Utils.getDomainGroups(ManagementSecurityUtils.getSecurityDomain(plugin),plugin.getPluginContext().getConfigContext().getConfigServer(),true);
                removeExistingPrincipals(domainGrps,false);
                Object groups[] = domainGrps.toArray();

                PrincipalChooserDialog dialog = new PrincipalChooserDialog(MgmtConsole.getMgmtConsole(), users, groups, false);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == JMADialog.CLOSE_OK) {
                    String principalName = dialog.getSelectedItem();
                    boolean isUser = dialog.getSelectedItemWithPrefix().startsWith(PrincipalChooserDialog.USER_PREFIX);
                    AbstractPermissions newPerms = permsModel.newPermissions(new AbstractPermissions.Principal(principalName, isUser));
                    newPerms.setScopeBits(permsModel.getAvailableScopeTypes()[0].getBits());  // set a default scope
                    listModel.addElement(newPerms);
                    principalsList.setSelectedIndex(listModel.indexOf(newPerms));
                    deleteButton.setEnabled(true);
                    modelChanged();
                }
            }


        });
        deleteButton = new JButton("Delete");
        deleteButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int index = principalsList.getSelectedIndex();
                if (index > -1 && index < listModel.getSize()){
                    listModel.remove(index);
                    modelChanged();
                }
                if (listModel.getSize() > 0) {
                    principalsList.setSelectedIndex(Math.max(0, index - 1));
                } else {
                    current = null;
                    renderDetails(current);
                    deleteButton.setEnabled(false);
                }
            }
        });
        JPartitionPanel buttonsPanel = JPartitionPanel.merge("p,p,r", true, JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0,
                new JComponent[]
                        {addButton, deleteButton});

        JPartitionPanel membersPanel = JPartitionPanel.merge("r,p", false,
                new JComponent[]
                        {membersScroll, buttonsPanel});

        topPanel.add(membersPanel);
        return topPanel;
    }


    private void renderDetails(AbstractPermissions selexn) {
        renderScope(selexn);
        renderPerms(selexn);
    }

    private void renderPerms(AbstractPermissions selexn) {
        int permissionsBits = selexn == null ? 0 : selexn.getPermissionsBits();
        itsMe = true;
        try {
            for (int i = 0; i < permissionChx.length; i++) {
                JCheckBox[] jCheckBoxes = permissionChx[i];
                int allowBit = ((Integer) jCheckBoxes[0].getClientProperty(chkBoxBit)).intValue();
                jCheckBoxes[0].setSelected((allowBit & permissionsBits) == allowBit);
                jCheckBoxes[0].setEnabled(selexn != null);
                int denyBit = ((Integer) jCheckBoxes[1].getClientProperty(chkBoxBit)).intValue();
                jCheckBoxes[1].setSelected((denyBit & permissionsBits) == denyBit);
                jCheckBoxes[1].setEnabled(selexn != null);
            }
        } finally {
            itsMe = false;
        }
    }

    private void renderScope(AbstractPermissions selexn) {
        int scopeBits = selexn == null ? 0 : selexn.getScopeBits();
        PermissionsList.ScopeType[] availableScopeTypes = permsModel.getAvailableScopeTypes();
        itsMe = true;
        try {
            if (selexn != null) {
                for (int i = 0; i < availableScopeTypes.length; i++) {
                    PermissionsList.ScopeType scopeType = availableScopeTypes[i];
                    if (scopeType.getBits() == scopeBits) {
                        scopesCombo.setSelectedIndex(i);
                        return;
                    }
                }
            }
            scopesCombo.setSelectedIndex(-1);
        } finally {
            scopesCombo.setEnabled(selexn != null);
            itsMe = false;
        }
    }

    private void modelChanged() {
        okAction.setEnabled(true);

    }

    @Override
    protected boolean canClose() {
        int res = JOptionPane.OK_OPTION;
        if (okAction.isEnabled()) {
            res = JOptionPane.showConfirmDialog(this, JPropSheetDialog.CHANGES, JPropSheetDialog.CHANGES_TITLE,
                     JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        }
        return (res == JOptionPane.OK_OPTION);
    }

    class PrincipalCellRenderer extends DefaultListCellRenderer {

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel res = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            AbstractPermissions perms = (AbstractPermissions) value;
            try {
                AbstractPermissions.Principal principal = perms.getPrincipal();
                if (principal.isUser())
                {
                    res.setIcon(ResourceManager.getIcon(getClass(), "type/AUTHENTICATION_USER"));
                }
                if (principal.isGroup())
                {
                    res.setIcon(ResourceManager.getIcon(getClass(), "type/AUTHENTICATION_GROUP"));
                }
            }
            catch (Exception e) {
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
            }

            return res;
        }
    }



    private void removeExistingPrincipals(Set allPrincipals,boolean forUsers) {
        for (Iterator iterator = allPrincipals.iterator(); iterator.hasNext();) {
            IConfigBean bean  =  (IConfigBean) iterator.next();
            IConfigPath attributeName = forUsers?PrincipalChooserDialog.USER_NAME:PrincipalChooserDialog.GROUP_NAME;
            String name = (String)bean.getAttribute(attributeName);
            Enumeration enumeration = listModel.elements();
            while (enumeration.hasMoreElements()) {
                AbstractPermissions.Principal principal = ((AbstractPermissions) enumeration.nextElement()).getPrincipal();
                if (principal.getName().equals(name)) {
                    iterator.remove();
                }
            }
        }
    }

    private class SortedListModel extends DefaultListModel {
        private Comparator comparator;

        public SortedListModel(List list) {
            this(list,null);
        }

        public SortedListModel(List list, Comparator comparator) {
            this.comparator = comparator;
            if(comparator==null)
            {
                Collections.sort(list);
            }
            else
            {
                Collections.sort(list,comparator);
            }
            addElements(list);
        }
        
        private void addElements(List list) {
            
            for (Iterator iterator = list.iterator(); iterator.hasNext();) {
                super.addElement(iterator.next());
            }
        }

        @Override
        public void addElement(Object obj) {
            Object[] objects = super.toArray();
            int index;
            if(comparator==null)
            {
                index = Arrays.binarySearch(objects, obj);
            }
            else
            {
                index = Arrays.binarySearch(objects, obj,comparator);
            }
            super.insertElementAt(obj,index<0?(-index)-1:index);
        }

    }

    public class PrincipalsComparator implements Comparator {
        @Override
        public int compare(Object o1, Object o2) {
            AbstractPermissions p1 = ((AbstractPermissions) o1);
            AbstractPermissions p2 = ((AbstractPermissions) o2);
            return p1.getPrincipal().getName().compareToIgnoreCase(p2.getPrincipal().getName());
        }
    }

    public class MyOKAction extends BasicGuiAction {
        public MyOKAction() {
            super("dialog.ok");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Enumeration enumeration = listModel.elements();
            while (enumeration.hasMoreElements()) {
                AbstractPermissions perms = (AbstractPermissions) enumeration.nextElement();
                if (perms.getPermissionsBits() == 0) {
                    JOptionPane.showMessageDialog(PermissionsDialog.this, "No permissions have been set for "+perms.getPrincipal().getName(), "Invalid permissions",
                            JOptionPane.WARNING_MESSAGE);
                    return;
                }
            }
            getDefaultOKAction().actionPerformed(evt);
        }
    }
}
